package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.ActualParameter;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.Invocation;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterImpl;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.expression.impl.InvocationImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterImpl;


public class ActualParameterImpl extends ModelInstance<ActualParameter,Sql> implements ActualParameter {

    public static final String KEY_LETTERS = "ActualParameter";
    public static final ActualParameter EMPTY_ACTUALPARAMETER = new EmptyActualParameter();

    private Sql context;

    // constructors
    private ActualParameterImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_invocation_expression_number = "";
        ref_expression_number = "";
        ref_next_expression_number = "";
        ref_invoked_parent_name = "";
        ref_invoked_parent_package = "";
        ref_invoked_name = "";
        ref_param_name = "";
        R3904_FormalParameter_inst = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        R3905_follows_ActualParameter_inst = ActualParameterImpl.EMPTY_ACTUALPARAMETER;
        R3905_precedes_ActualParameter_inst = ActualParameterImpl.EMPTY_ACTUALPARAMETER;
        R793_Invocation_inst = InvocationImpl.EMPTY_INVOCATION;
        R794_parameter_value_specified_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private ActualParameterImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_invocation_expression_number, String ref_expression_number, String ref_next_expression_number, String ref_invoked_parent_name, String ref_invoked_parent_package, String ref_invoked_name, String ref_param_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_invocation_expression_number = ref_invocation_expression_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_next_expression_number = ref_next_expression_number;
        this.ref_invoked_parent_name = ref_invoked_parent_name;
        this.ref_invoked_parent_package = ref_invoked_parent_package;
        this.ref_invoked_name = ref_invoked_name;
        this.ref_param_name = ref_param_name;
        R3904_FormalParameter_inst = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        R3905_follows_ActualParameter_inst = ActualParameterImpl.EMPTY_ACTUALPARAMETER;
        R3905_precedes_ActualParameter_inst = ActualParameterImpl.EMPTY_ACTUALPARAMETER;
        R793_Invocation_inst = InvocationImpl.EMPTY_INVOCATION;
        R794_parameter_value_specified_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static ActualParameter create( Sql context ) throws XtumlException {
        ActualParameter newActualParameter = new ActualParameterImpl( context );
        if ( context.addInstance( newActualParameter ) ) {
            newActualParameter.getRunContext().addChange(new InstanceCreatedDelta(newActualParameter, KEY_LETTERS));
            return newActualParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActualParameter create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_invocation_expression_number, String ref_expression_number, String ref_next_expression_number, String ref_invoked_parent_name, String ref_invoked_parent_package, String ref_invoked_name, String ref_param_name ) throws XtumlException {
        ActualParameter newActualParameter = new ActualParameterImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_invocation_expression_number, ref_expression_number, ref_next_expression_number, ref_invoked_parent_name, ref_invoked_parent_package, ref_invoked_name, ref_param_name );
        if ( context.addInstance( newActualParameter ) ) {
            return newActualParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setParent_name( ref_parent_name );
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setParent_package( ref_parent_package );
        }
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setBody_name( ref_body_name );
        }
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setBlock_number( ref_block_number );
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setStatement_number( ref_statement_number );
        }
    }
    private String ref_invocation_expression_number;
    @Override
    public void setInvocation_expression_number(String ref_invocation_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_invocation_expression_number, this.ref_invocation_expression_number)) {
            final String oldValue = this.ref_invocation_expression_number;
            this.ref_invocation_expression_number = ref_invocation_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invocation_expression_number", oldValue, this.ref_invocation_expression_number));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setInvocation_expression_number( ref_invocation_expression_number );
        }
    }
    @Override
    public String getInvocation_expression_number() throws XtumlException {
        checkLiving();
        return ref_invocation_expression_number;
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
            if ( !R3905_follows_ActualParameter().isEmpty() ) R3905_follows_ActualParameter().setNext_expression_number( ref_expression_number );
        }
    }
    private String ref_next_expression_number;
    @Override
    public void setNext_expression_number(String ref_next_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_next_expression_number, this.ref_next_expression_number)) {
            final String oldValue = this.ref_next_expression_number;
            this.ref_next_expression_number = ref_next_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_next_expression_number", oldValue, this.ref_next_expression_number));
        }
    }
    @Override
    public String getNext_expression_number() throws XtumlException {
        checkLiving();
        return ref_next_expression_number;
    }
    private String ref_invoked_parent_name;
    @Override
    public String getInvoked_parent_name() throws XtumlException {
        checkLiving();
        return ref_invoked_parent_name;
    }
    @Override
    public void setInvoked_parent_name(String ref_invoked_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_invoked_parent_name, this.ref_invoked_parent_name)) {
            final String oldValue = this.ref_invoked_parent_name;
            this.ref_invoked_parent_name = ref_invoked_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invoked_parent_name", oldValue, this.ref_invoked_parent_name));
        }
    }
    private String ref_invoked_parent_package;
    @Override
    public String getInvoked_parent_package() throws XtumlException {
        checkLiving();
        return ref_invoked_parent_package;
    }
    @Override
    public void setInvoked_parent_package(String ref_invoked_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_invoked_parent_package, this.ref_invoked_parent_package)) {
            final String oldValue = this.ref_invoked_parent_package;
            this.ref_invoked_parent_package = ref_invoked_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invoked_parent_package", oldValue, this.ref_invoked_parent_package));
        }
    }
    private String ref_invoked_name;
    @Override
    public String getInvoked_name() throws XtumlException {
        checkLiving();
        return ref_invoked_name;
    }
    @Override
    public void setInvoked_name(String ref_invoked_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_invoked_name, this.ref_invoked_name)) {
            final String oldValue = this.ref_invoked_name;
            this.ref_invoked_name = ref_invoked_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invoked_name", oldValue, this.ref_invoked_name));
        }
    }
    private String ref_param_name;
    @Override
    public String getParam_name() throws XtumlException {
        checkLiving();
        return ref_param_name;
    }
    @Override
    public void setParam_name(String ref_param_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_param_name, this.ref_param_name)) {
            final String oldValue = this.ref_param_name;
            this.ref_param_name = ref_param_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_param_name", oldValue, this.ref_param_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getInvocation_expression_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Expression expr = self().R794_parameter_value_specified_by_Expression();
        expr.render();
        String expression_body = context().T().body();
        context().T().pop_buffer();
        context().T().include( "expression/t.actualparameter.java", expression_body );
    }



    // static operations


    // events


    // selections
    private FormalParameter R3904_FormalParameter_inst;
    @Override
    public void setR3904_FormalParameter( FormalParameter inst ) {
        R3904_FormalParameter_inst = inst;
    }
    @Override
    public FormalParameter R3904_FormalParameter() throws XtumlException {
        return R3904_FormalParameter_inst;
    }
    private ActualParameter R3905_follows_ActualParameter_inst;
    @Override
    public void setR3905_follows_ActualParameter( ActualParameter inst ) {
        R3905_follows_ActualParameter_inst = inst;
    }
    @Override
    public ActualParameter R3905_follows_ActualParameter() throws XtumlException {
        return R3905_follows_ActualParameter_inst;
    }
    private ActualParameter R3905_precedes_ActualParameter_inst;
    @Override
    public void setR3905_precedes_ActualParameter( ActualParameter inst ) {
        R3905_precedes_ActualParameter_inst = inst;
    }
    @Override
    public ActualParameter R3905_precedes_ActualParameter() throws XtumlException {
        return R3905_precedes_ActualParameter_inst;
    }
    private Invocation R793_Invocation_inst;
    @Override
    public void setR793_Invocation( Invocation inst ) {
        R793_Invocation_inst = inst;
    }
    @Override
    public Invocation R793_Invocation() throws XtumlException {
        return R793_Invocation_inst;
    }
    private Expression R794_parameter_value_specified_by_Expression_inst;
    @Override
    public void setR794_parameter_value_specified_by_Expression( Expression inst ) {
        R794_parameter_value_specified_by_Expression_inst = inst;
    }
    @Override
    public Expression R794_parameter_value_specified_by_Expression() throws XtumlException {
        return R794_parameter_value_specified_by_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActualParameter self() {
        return this;
    }

    @Override
    public ActualParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACTUALPARAMETER;
    }

}

class EmptyActualParameter extends ModelInstance<ActualParameter,Sql> implements ActualParameter {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInvocation_expression_number( String ref_invocation_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvocation_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setNext_expression_number( String ref_next_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getNext_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getInvoked_parent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInvoked_parent_name( String ref_invoked_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvoked_parent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInvoked_parent_package( String ref_invoked_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvoked_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInvoked_name( String ref_invoked_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParam_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParam_name( String ref_param_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public FormalParameter R3904_FormalParameter() {
        return FormalParameterImpl.EMPTY_FORMALPARAMETER;
    }
    @Override
    public ActualParameter R3905_follows_ActualParameter() {
        return ActualParameterImpl.EMPTY_ACTUALPARAMETER;
    }
    @Override
    public ActualParameter R3905_precedes_ActualParameter() {
        return ActualParameterImpl.EMPTY_ACTUALPARAMETER;
    }
    @Override
    public Invocation R793_Invocation() {
        return InvocationImpl.EMPTY_INVOCATION;
    }
    @Override
    public Expression R794_parameter_value_specified_by_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return ActualParameterImpl.KEY_LETTERS;
    }

    @Override
    public ActualParameter self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActualParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ActualParameterImpl.EMPTY_ACTUALPARAMETER;
    }

}
