package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.InstanceSelectorSet;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.SetSelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.InstanceSelectorSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.SetSelectorSetImpl;
import io.ciera.tool.sql.architecture.expression.SelectRelatedSet;
import io.ciera.tool.sql.architecture.expression.impl.SelectRelatedSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import types.Mult;


public class SelectorSetImpl extends InstanceSet<SelectorSet,Selector> implements SelectorSet {

    public SelectorSetImpl() {
    }

    public SelectorSetImpl(Comparator<? super Selector> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setRel_comp_package( String ref_rel_comp_package ) throws XtumlException {
        for ( Selector selector : this ) selector.setRel_comp_package( ref_rel_comp_package );
    }
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( Selector selector : this ) selector.setType_name( ref_type_name );
    }
    @Override
    public void setParent_name( String m_parent_name ) throws XtumlException {
        for ( Selector selector : this ) selector.setParent_name( m_parent_name );
    }
    @Override
    public void setParent_package( String m_parent_package ) throws XtumlException {
        for ( Selector selector : this ) selector.setParent_package( m_parent_package );
    }
    @Override
    public void setRel_comp_name( String ref_rel_comp_name ) throws XtumlException {
        for ( Selector selector : this ) selector.setRel_comp_name( ref_rel_comp_name );
    }
    @Override
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        for ( Selector selector : this ) selector.setType_reference_name( ref_type_reference_name );
    }
    @Override
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        for ( Selector selector : this ) selector.setRel_name( ref_rel_name );
    }
    @Override
    public void setMultiplicity( Mult m_multiplicity ) throws XtumlException {
        for ( Selector selector : this ) selector.setMultiplicity( m_multiplicity );
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( Selector selector : this ) selector.setType_package( ref_type_package );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( Selector selector : this ) selector.setName( m_name );
    }


    // selections
    @Override
    public InstanceSelectorSet R445_is_a_InstanceSelector() throws XtumlException {
        InstanceSelectorSet instanceselectorset = new InstanceSelectorSetImpl();
        for ( Selector selector : this ) instanceselectorset.add( selector.R445_is_a_InstanceSelector() );
        return instanceselectorset;
    }
    @Override
    public SetSelectorSet R445_is_a_SetSelector() throws XtumlException {
        SetSelectorSet setselectorset = new SetSelectorSetImpl();
        for ( Selector selector : this ) setselectorset.add( selector.R445_is_a_SetSelector() );
        return setselectorset;
    }
    @Override
    public TypeReferenceSet R446_selects_instances_of_TypeReference() throws XtumlException {
        TypeReferenceSet typereferenceset = new TypeReferenceSetImpl();
        for ( Selector selector : this ) typereferenceset.add( selector.R446_selects_instances_of_TypeReference() );
        return typereferenceset;
    }
    @Override
    public ClassRelationshipSet R4512_traverses_across_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( Selector selector : this ) classrelationshipset.add( selector.R4512_traverses_across_ClassRelationship() );
        return classrelationshipset;
    }
    @Override
    public SelectRelatedSet R797_invoked_by_SelectRelated() throws XtumlException {
        SelectRelatedSet selectrelatedset = new SelectRelatedSetImpl();
        for ( Selector selector : this ) selectrelatedset.addAll( selector.R797_invoked_by_SelectRelated() );
        return selectrelatedset;
    }


    @Override
    public Selector nullElement() {
        return SelectorImpl.EMPTY_SELECTOR;
    }

    @Override
    public SelectorSet emptySet() {
      return new SelectorSetImpl();
    }

    @Override
    public SelectorSet emptySet(Comparator<? super Selector> comp) {
      return new SelectorSetImpl(comp);
    }

    @Override
    public List<Selector> elements() {
        Selector[] elements = toArray(new Selector[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
