package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.InstSetSet;
import io.ciera.tool.sql.architecture.classes.InstanceSelectorSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.OperationSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.InstSetSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.InstanceSelectorSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.OperationSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.InstancePopulationSelectorSetImpl;
import io.ciera.tool.sql.architecture.expression.CreationSet;
import io.ciera.tool.sql.architecture.expression.impl.CreationSetImpl;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.architecture.statemachine.StateMachineSet;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineSetImpl;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;
import io.ciera.tool.sql.loader.EventInstanceLoaderSet;
import io.ciera.tool.sql.loader.impl.EventInstanceLoaderSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClassSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ModelInstSetImpl extends InstanceSet<ModelInstSet,ModelInst> implements ModelInstSet {

    public ModelInstSetImpl() {
    }

    public ModelInstSetImpl(Comparator<? super ModelInst> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setComp_name( ref_comp_name );
    }
    @Override
    public void setKey_letters( String m_key_letters ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setKey_letters( m_key_letters );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setPackage( ref_package );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setComp_package( ref_comp_package );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setName( ref_name );
    }
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setObj_ID( ref_Obj_ID );
    }
    @Override
    public void setExtends( String m_extends ) throws XtumlException {
        for ( ModelInst modelinst : this ) modelinst.setExtends( m_extends );
    }


    // selections
    @Override
    public EventInstanceLoaderSet R3017_EventInstanceLoader() throws XtumlException {
        EventInstanceLoaderSet eventinstanceloaderset = new EventInstanceLoaderSetImpl();
        for ( ModelInst modelinst : this ) eventinstanceloaderset.add( modelinst.R3017_EventInstanceLoader() );
        return eventinstanceloaderset;
    }
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( ModelInst modelinst : this ) fileset.add( modelinst.R401_is_a_File() );
        return fileset;
    }
    @Override
    public InstSetSet R406_is_type_of_single_element_in_InstSet() throws XtumlException {
        InstSetSet instsetset = new InstSetSetImpl();
        for ( ModelInst modelinst : this ) instsetset.add( modelinst.R406_is_type_of_single_element_in_InstSet() );
        return instsetset;
    }
    @Override
    public TypeSet R407_is_a_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( ModelInst modelinst : this ) typeset.add( modelinst.R407_is_a_Type() );
        return typeset;
    }
    @Override
    public ComponentDefinitionSet R408_forms_instance_population_of_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( ModelInst modelinst : this ) componentdefinitionset.add( modelinst.R408_forms_instance_population_of_ComponentDefinition() );
        return componentdefinitionset;
    }
    @Override
    public ModelClassSet R409_is_transformed_from_ModelClass() throws XtumlException {
        ModelClassSet modelclassset = new ModelClassSetImpl();
        for ( ModelInst modelinst : this ) modelclassset.add( modelinst.R409_is_transformed_from_ModelClass() );
        return modelclassset;
    }
    @Override
    public AttributeSet R410_data_abstracted_by_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( ModelInst modelinst : this ) attributeset.addAll( modelinst.R410_data_abstracted_by_Attribute() );
        return attributeset;
    }
    @Override
    public OperationSet R416_provides_Operation() throws XtumlException {
        OperationSet operationset = new OperationSetImpl();
        for ( ModelInst modelinst : this ) operationset.addAll( modelinst.R416_provides_Operation() );
        return operationset;
    }
    @Override
    public ClassRelationshipSet R434_participates_in_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( ModelInst modelinst : this ) classrelationshipset.addAll( modelinst.R434_participates_in_ClassRelationship() );
        return classrelationshipset;
    }
    @Override
    public ClassRelationshipSet R435_formalizes_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( ModelInst modelinst : this ) classrelationshipset.addAll( modelinst.R435_formalizes_ClassRelationship() );
        return classrelationshipset;
    }
    @Override
    public InstanceSelectorSet R442_selects_instances_through_InstanceSelector() throws XtumlException {
        InstanceSelectorSet instanceselectorset = new InstanceSelectorSetImpl();
        for ( ModelInst modelinst : this ) instanceselectorset.addAll( modelinst.R442_selects_instances_through_InstanceSelector() );
        return instanceselectorset;
    }
    @Override
    public InstancePopulationSelectorSet R449_extent_accessed_by_InstancePopulationSelector() throws XtumlException {
        InstancePopulationSelectorSet instancepopulationselectorset = new InstancePopulationSelectorSetImpl();
        for ( ModelInst modelinst : this ) instancepopulationselectorset.add( modelinst.R449_extent_accessed_by_InstancePopulationSelector() );
        return instancepopulationselectorset;
    }
    @Override
    public StateMachineSet R4750_behavior_modeled_by_StateMachine() throws XtumlException {
        StateMachineSet statemachineset = new StateMachineSetImpl();
        for ( ModelInst modelinst : this ) statemachineset.add( modelinst.R4750_behavior_modeled_by_StateMachine() );
        return statemachineset;
    }
    @Override
    public CreationSet R780_created_by_Creation() throws XtumlException {
        CreationSet creationset = new CreationSetImpl();
        for ( ModelInst modelinst : this ) creationset.addAll( modelinst.R780_created_by_Creation() );
        return creationset;
    }


    @Override
    public ModelInst nullElement() {
        return ModelInstImpl.EMPTY_MODELINST;
    }

    @Override
    public ModelInstSet emptySet() {
      return new ModelInstSetImpl();
    }

    @Override
    public ModelInstSet emptySet(Comparator<? super ModelInst> comp) {
      return new ModelInstSetImpl(comp);
    }

    @Override
    public List<ModelInst> elements() {
        ModelInst[] elements = toArray(new ModelInst[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
