package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum TransitionType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    CANT_HAPPEN( 1 ),
    IGNORE( 2 ),
    TRANSITION( 0 );

    private final int value;

    TransitionType() {
        value = -1;
    }

    TransitionType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof TransitionType) {
            return null != value && this.value == ((TransitionType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static TransitionType deserialize(Object o) throws XtumlException {
        if (o instanceof TransitionType) {
            return (TransitionType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "transitiontype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(TransitionType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static TransitionType valueOf(int value) {
        switch( value ) {
        case 1:
            return CANT_HAPPEN;
        case 2:
            return IGNORE;
        case 0:
            return TRANSITION;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
