package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Breakpoint_Type implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    ASSOCIATION( 0 ),
    ATTRIBUTE( 1 ),
    EVENT_BP( 2 ),
    INSTANCE( 3 ),
    OAL( 4 ),
    STATE( 5 );

    private final int value;

    Breakpoint_Type() {
        value = -1;
    }

    Breakpoint_Type( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Breakpoint_Type) {
            return null != value && this.value == ((Breakpoint_Type)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Breakpoint_Type deserialize(Object o) throws XtumlException {
        if (o instanceof Breakpoint_Type) {
            return (Breakpoint_Type)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "breakpoint_type".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Breakpoint_Type.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static Breakpoint_Type valueOf(int value) {
        switch( value ) {
        case 0:
            return ASSOCIATION;
        case 1:
            return ATTRIBUTE;
        case 2:
            return EVENT_BP;
        case 3:
            return INSTANCE;
        case 4:
            return OAL;
        case 5:
            return STATE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
