package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.V_BIN;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class V_BINImpl extends ModelInstance<V_BIN,Sql> implements V_BIN {

    public static final String KEY_LETTERS = "V_BIN";
    public static final V_BIN EMPTY_V_BIN = new EmptyV_BIN();

    private Sql context;

    // constructors
    private V_BINImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Right_Value_ID = UniqueId.random();
        ref_Left_Value_ID = UniqueId.random();
        m_Operator = "";
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R802_has_left_Value_inst = ValueImpl.EMPTY_VALUE;
        R803_has_right_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private V_BINImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Right_Value_ID, UniqueId ref_Left_Value_ID, String m_Operator ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Right_Value_ID = ref_Right_Value_ID;
        this.ref_Left_Value_ID = ref_Left_Value_ID;
        this.m_Operator = m_Operator;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R802_has_left_Value_inst = ValueImpl.EMPTY_VALUE;
        R803_has_right_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static V_BIN create( Sql context ) throws XtumlException {
        V_BIN newV_BIN = new V_BINImpl( context );
        if ( context.addInstance( newV_BIN ) ) {
            newV_BIN.getRunContext().addChange(new InstanceCreatedDelta(newV_BIN, KEY_LETTERS));
            return newV_BIN;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static V_BIN create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Right_Value_ID, UniqueId ref_Left_Value_ID, String m_Operator ) throws XtumlException {
        V_BIN newV_BIN = new V_BINImpl( context, instanceId, ref_Value_ID, ref_Right_Value_ID, ref_Left_Value_ID, m_Operator );
        if ( context.addInstance( newV_BIN ) ) {
            return newV_BIN;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private UniqueId ref_Right_Value_ID;
    @Override
    public void setRight_Value_ID(UniqueId ref_Right_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Right_Value_ID.inequality( this.ref_Right_Value_ID)) {
            final UniqueId oldValue = this.ref_Right_Value_ID;
            this.ref_Right_Value_ID = ref_Right_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Right_Value_ID", oldValue, this.ref_Right_Value_ID));
        }
    }
    @Override
    public UniqueId getRight_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Right_Value_ID;
    }
    private UniqueId ref_Left_Value_ID;
    @Override
    public void setLeft_Value_ID(UniqueId ref_Left_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Left_Value_ID.inequality( this.ref_Left_Value_ID)) {
            final UniqueId oldValue = this.ref_Left_Value_ID;
            this.ref_Left_Value_ID = ref_Left_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Left_Value_ID", oldValue, this.ref_Left_Value_ID));
        }
    }
    @Override
    public UniqueId getLeft_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Left_Value_ID;
    }
    private String m_Operator;
    @Override
    public void setOperator(String m_Operator) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Operator, this.m_Operator)) {
            final String oldValue = this.m_Operator;
            this.m_Operator = m_Operator;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Operator", oldValue, this.m_Operator));
        }
    }
    @Override
    public String getOperator() throws XtumlException {
        checkLiving();
        return m_Operator;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private Value R802_has_left_Value_inst;
    @Override
    public void setR802_has_left_Value( Value inst ) {
        R802_has_left_Value_inst = inst;
    }
    @Override
    public Value R802_has_left_Value() throws XtumlException {
        return R802_has_left_Value_inst;
    }
    private Value R803_has_right_Value_inst;
    @Override
    public void setR803_has_right_Value( Value inst ) {
        R803_has_right_Value_inst = inst;
    }
    @Override
    public Value R803_has_right_Value() throws XtumlException {
        return R803_has_right_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public V_BIN self() {
        return this;
    }

    @Override
    public V_BIN oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_V_BIN;
    }

}

class EmptyV_BIN extends ModelInstance<V_BIN,Sql> implements V_BIN {

    // attributes
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRight_Value_ID( UniqueId ref_Right_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRight_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLeft_Value_ID( UniqueId ref_Left_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getLeft_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOperator( String m_Operator ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getOperator() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R802_has_left_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R803_has_right_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return V_BINImpl.KEY_LETTERS;
    }

    @Override
    public V_BIN self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public V_BIN oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return V_BINImpl.EMPTY_V_BIN;
    }

}
