package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;
import io.ciera.tool.sql.ooaofooa.value.OperationValue;
import io.ciera.tool.sql.ooaofooa.value.SelectedReference;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.OperationValueImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class SelectedReferenceImpl extends ModelInstance<SelectedReference,Sql> implements SelectedReference {

    public static final String KEY_LETTERS = "V_SLR";
    public static final SelectedReference EMPTY_SELECTEDREFERENCE = new EmptySelectedReference();

    private Sql context;

    // constructors
    private SelectedReferenceImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Attr_ID = UniqueId.random();
        ref_Op_Value_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R812_member_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R825_value_OperationValue_inst = OperationValueImpl.EMPTY_OPERATIONVALUE;
    }

    private SelectedReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, UniqueId ref_Op_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Op_Value_ID = ref_Op_Value_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R812_member_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R825_value_OperationValue_inst = OperationValueImpl.EMPTY_OPERATIONVALUE;
    }

    public static SelectedReference create( Sql context ) throws XtumlException {
        SelectedReference newSelectedReference = new SelectedReferenceImpl( context );
        if ( context.addInstance( newSelectedReference ) ) {
            newSelectedReference.getRunContext().addChange(new InstanceCreatedDelta(newSelectedReference, KEY_LETTERS));
            return newSelectedReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SelectedReference create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, UniqueId ref_Op_Value_ID ) throws XtumlException {
        SelectedReference newSelectedReference = new SelectedReferenceImpl( context, instanceId, ref_Value_ID, ref_Obj_ID, ref_Attr_ID, ref_Op_Value_ID );
        if ( context.addInstance( newSelectedReference ) ) {
            return newSelectedReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    private UniqueId ref_Op_Value_ID;
    @Override
    public void setOp_Value_ID(UniqueId ref_Op_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Op_Value_ID.inequality( this.ref_Op_Value_ID)) {
            final UniqueId oldValue = this.ref_Op_Value_ID;
            this.ref_Op_Value_ID = ref_Op_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Op_Value_ID", oldValue, this.ref_Op_Value_ID));
        }
    }
    @Override
    public UniqueId getOp_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Op_Value_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private O_ATTR R812_member_O_ATTR_inst;
    @Override
    public void setR812_member_O_ATTR( O_ATTR inst ) {
        R812_member_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R812_member_O_ATTR() throws XtumlException {
        return R812_member_O_ATTR_inst;
    }
    private OperationValue R825_value_OperationValue_inst;
    @Override
    public void setR825_value_OperationValue( OperationValue inst ) {
        R825_value_OperationValue_inst = inst;
    }
    @Override
    public OperationValue R825_value_OperationValue() throws XtumlException {
        return R825_value_OperationValue_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SelectedReference self() {
        return this;
    }

    @Override
    public SelectedReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SELECTEDREFERENCE;
    }

}

class EmptySelectedReference extends ModelInstance<SelectedReference,Sql> implements SelectedReference {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOp_Value_ID( UniqueId ref_Op_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOp_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public O_ATTR R812_member_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public OperationValue R825_value_OperationValue() {
        return OperationValueImpl.EMPTY_OPERATIONVALUE;
    }


    @Override
    public String getKeyLetters() {
        return SelectedReferenceImpl.KEY_LETTERS;
    }

    @Override
    public SelectedReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SelectedReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SelectedReferenceImpl.EMPTY_SELECTEDREFERENCE;
    }

}
