package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.EventDatumValue;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReference;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReferenceSet;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.EventParameterReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class EventDatumValueImpl extends ModelInstance<EventDatumValue,Sql> implements EventDatumValue {

    public static final String KEY_LETTERS = "V_EDV";
    public static final EventDatumValue EMPTY_EVENTDATUMVALUE = new EmptyEventDatumValue();

    private Sql context;

    // constructors
    private EventDatumValueImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R834_EventParameterReference_set = new EventParameterReferenceSetImpl();
    }

    private EventDatumValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R834_EventParameterReference_set = new EventParameterReferenceSetImpl();
    }

    public static EventDatumValue create( Sql context ) throws XtumlException {
        EventDatumValue newEventDatumValue = new EventDatumValueImpl( context );
        if ( context.addInstance( newEventDatumValue ) ) {
            newEventDatumValue.getRunContext().addChange(new InstanceCreatedDelta(newEventDatumValue, KEY_LETTERS));
            return newEventDatumValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventDatumValue create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID ) throws XtumlException {
        EventDatumValue newEventDatumValue = new EventDatumValueImpl( context, instanceId, ref_Value_ID );
        if ( context.addInstance( newEventDatumValue ) ) {
            return newEventDatumValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
            if ( !R834_EventParameterReference().isEmpty() ) R834_EventParameterReference().setValue_ID( ref_Value_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private EventParameterReferenceSet R834_EventParameterReference_set;
    @Override
    public void addR834_EventParameterReference( EventParameterReference inst ) {
        R834_EventParameterReference_set.add(inst);
    }
    @Override
    public void removeR834_EventParameterReference( EventParameterReference inst ) {
        R834_EventParameterReference_set.remove(inst);
    }
    @Override
    public EventParameterReferenceSet R834_EventParameterReference() throws XtumlException {
        return R834_EventParameterReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventDatumValue self() {
        return this;
    }

    @Override
    public EventDatumValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTDATUMVALUE;
    }

}

class EmptyEventDatumValue extends ModelInstance<EventDatumValue,Sql> implements EventDatumValue {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public EventParameterReferenceSet R834_EventParameterReference() {
        return (new EventParameterReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return EventDatumValueImpl.KEY_LETTERS;
    }

    @Override
    public EventDatumValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventDatumValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventDatumValueImpl.EMPTY_EVENTDATUMVALUE;
    }

}
