package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ReferredToClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.ReferredToClassInAssocSet;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferredToClassInAssocSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifier;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifierAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifierAttributeSet;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ClassIdentifierAttributeSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class ClassIdentifierImpl extends ModelInstance<ClassIdentifier,Sql> implements ClassIdentifier {

    public static final String KEY_LETTERS = "O_ID";
    public static final ClassIdentifier EMPTY_CLASSIDENTIFIER = new EmptyClassIdentifier();

    private Sql context;

    // constructors
    private ClassIdentifierImpl( Sql context ) {
        this.context = context;
        m_Oid_ID = 0;
        ref_Obj_ID = UniqueId.random();
        R104_identifies_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R105_is_made_up_of__ClassIdentifierAttribute_set = new ClassIdentifierAttributeSetImpl();
        R109_identifies_for_this_association__ReferredToClassInAssoc_set = new ReferredToClassInAssocSetImpl();
    }

    private ClassIdentifierImpl( Sql context, UniqueId instanceId, int m_Oid_ID, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.m_Oid_ID = m_Oid_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        R104_identifies_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R105_is_made_up_of__ClassIdentifierAttribute_set = new ClassIdentifierAttributeSetImpl();
        R109_identifies_for_this_association__ReferredToClassInAssoc_set = new ReferredToClassInAssocSetImpl();
    }

    public static ClassIdentifier create( Sql context ) throws XtumlException {
        ClassIdentifier newClassIdentifier = new ClassIdentifierImpl( context );
        if ( context.addInstance( newClassIdentifier ) ) {
            newClassIdentifier.getRunContext().addChange(new InstanceCreatedDelta(newClassIdentifier, KEY_LETTERS));
            return newClassIdentifier;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassIdentifier create( Sql context, UniqueId instanceId, int m_Oid_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        ClassIdentifier newClassIdentifier = new ClassIdentifierImpl( context, instanceId, m_Oid_ID, ref_Obj_ID );
        if ( context.addInstance( newClassIdentifier ) ) {
            return newClassIdentifier;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private int m_Oid_ID;
    @Override
    public int getOid_ID() throws XtumlException {
        checkLiving();
        return m_Oid_ID;
    }
    @Override
    public void setOid_ID(int m_Oid_ID) throws XtumlException {
        checkLiving();
        if (m_Oid_ID != this.m_Oid_ID) {
            final int oldValue = this.m_Oid_ID;
            this.m_Oid_ID = m_Oid_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Oid_ID", oldValue, this.m_Oid_ID));
            if ( !R109_identifies_for_this_association__ReferredToClassInAssoc().isEmpty() ) R109_identifies_for_this_association__ReferredToClassInAssoc().setOid_ID( m_Oid_ID );
            if ( !R105_is_made_up_of__ClassIdentifierAttribute().isEmpty() ) R105_is_made_up_of__ClassIdentifierAttribute().setOid_ID( m_Oid_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R105_is_made_up_of__ClassIdentifierAttribute().isEmpty() ) R105_is_made_up_of__ClassIdentifierAttribute().setObj_ID( ref_Obj_ID );
            if ( !R109_identifies_for_this_association__ReferredToClassInAssoc().isEmpty() ) R109_identifies_for_this_association__ReferredToClassInAssoc().setObj_ID( ref_Obj_ID );
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getOid_ID(), getObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ModelClass R104_identifies_ModelClass_inst;
    @Override
    public void setR104_identifies_ModelClass( ModelClass inst ) {
        R104_identifies_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R104_identifies_ModelClass() throws XtumlException {
        return R104_identifies_ModelClass_inst;
    }
    private ClassIdentifierAttributeSet R105_is_made_up_of__ClassIdentifierAttribute_set;
    @Override
    public void addR105_is_made_up_of__ClassIdentifierAttribute( ClassIdentifierAttribute inst ) {
        R105_is_made_up_of__ClassIdentifierAttribute_set.add(inst);
    }
    @Override
    public void removeR105_is_made_up_of__ClassIdentifierAttribute( ClassIdentifierAttribute inst ) {
        R105_is_made_up_of__ClassIdentifierAttribute_set.remove(inst);
    }
    @Override
    public ClassIdentifierAttributeSet R105_is_made_up_of__ClassIdentifierAttribute() throws XtumlException {
        return R105_is_made_up_of__ClassIdentifierAttribute_set;
    }
    private ReferredToClassInAssocSet R109_identifies_for_this_association__ReferredToClassInAssoc_set;
    @Override
    public void addR109_identifies_for_this_association__ReferredToClassInAssoc( ReferredToClassInAssoc inst ) {
        R109_identifies_for_this_association__ReferredToClassInAssoc_set.add(inst);
    }
    @Override
    public void removeR109_identifies_for_this_association__ReferredToClassInAssoc( ReferredToClassInAssoc inst ) {
        R109_identifies_for_this_association__ReferredToClassInAssoc_set.remove(inst);
    }
    @Override
    public ReferredToClassInAssocSet R109_identifies_for_this_association__ReferredToClassInAssoc() throws XtumlException {
        return R109_identifies_for_this_association__ReferredToClassInAssoc_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassIdentifier self() {
        return this;
    }

    @Override
    public ClassIdentifier oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSIDENTIFIER;
    }

}

class EmptyClassIdentifier extends ModelInstance<ClassIdentifier,Sql> implements ClassIdentifier {

    // attributes
    public int getOid_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOid_ID( int m_Oid_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ModelClass R104_identifies_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }
    @Override
    public ClassIdentifierAttributeSet R105_is_made_up_of__ClassIdentifierAttribute() {
        return (new ClassIdentifierAttributeSetImpl());
    }
    @Override
    public ReferredToClassInAssocSet R109_identifies_for_this_association__ReferredToClassInAssoc() {
        return (new ReferredToClassInAssocSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ClassIdentifierImpl.KEY_LETTERS;
    }

    @Override
    public ClassIdentifier self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassIdentifier oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassIdentifierImpl.EMPTY_CLASSIDENTIFIER;
    }

}
