package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.ProvidedSignalImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredSignalImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.SEMEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SignalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SEMEventImpl;


public class SignalEventImpl extends ModelInstance<SignalEvent,Sql> implements SignalEvent {

    public static final String KEY_LETTERS = "SM_SGEVT";
    public static final SignalEvent EMPTY_SIGNALEVENT = new EmptySignalEvent();

    private Sql context;

    // constructors
    private SignalEventImpl( Sql context ) {
        this.context = context;
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        ref_Provided_Signal_Id = UniqueId.random();
        ref_Required_Signal_Id = UniqueId.random();
        m_signal_name = "";
        R526_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R528_ProvidedSignal_inst = ProvidedSignalImpl.EMPTY_PROVIDEDSIGNAL;
        R529_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }

    private SignalEventImpl( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, UniqueId ref_Provided_Signal_Id, UniqueId ref_Required_Signal_Id, String m_signal_name ) {
        super(instanceId);
        this.context = context;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        this.ref_Provided_Signal_Id = ref_Provided_Signal_Id;
        this.ref_Required_Signal_Id = ref_Required_Signal_Id;
        this.m_signal_name = m_signal_name;
        R526_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R528_ProvidedSignal_inst = ProvidedSignalImpl.EMPTY_PROVIDEDSIGNAL;
        R529_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }

    public static SignalEvent create( Sql context ) throws XtumlException {
        SignalEvent newSignalEvent = new SignalEventImpl( context );
        if ( context.addInstance( newSignalEvent ) ) {
            newSignalEvent.getRunContext().addChange(new InstanceCreatedDelta(newSignalEvent, KEY_LETTERS));
            return newSignalEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SignalEvent create( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, UniqueId ref_Provided_Signal_Id, UniqueId ref_Required_Signal_Id, String m_signal_name ) throws XtumlException {
        SignalEvent newSignalEvent = new SignalEventImpl( context, instanceId, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated, ref_Provided_Signal_Id, ref_Required_Signal_Id, m_signal_name );
        if ( context.addInstance( newSignalEvent ) ) {
            return newSignalEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMevt_ID;
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }
    private UniqueId ref_Provided_Signal_Id;
    @Override
    public UniqueId getProvided_Signal_Id() throws XtumlException {
        checkLiving();
        return ref_Provided_Signal_Id;
    }
    @Override
    public void setProvided_Signal_Id(UniqueId ref_Provided_Signal_Id) throws XtumlException {
        checkLiving();
        if (ref_Provided_Signal_Id.inequality( this.ref_Provided_Signal_Id)) {
            final UniqueId oldValue = this.ref_Provided_Signal_Id;
            this.ref_Provided_Signal_Id = ref_Provided_Signal_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Provided_Signal_Id", oldValue, this.ref_Provided_Signal_Id));
        }
    }
    private UniqueId ref_Required_Signal_Id;
    @Override
    public void setRequired_Signal_Id(UniqueId ref_Required_Signal_Id) throws XtumlException {
        checkLiving();
        if (ref_Required_Signal_Id.inequality( this.ref_Required_Signal_Id)) {
            final UniqueId oldValue = this.ref_Required_Signal_Id;
            this.ref_Required_Signal_Id = ref_Required_Signal_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Required_Signal_Id", oldValue, this.ref_Required_Signal_Id));
        }
    }
    @Override
    public UniqueId getRequired_Signal_Id() throws XtumlException {
        checkLiving();
        return ref_Required_Signal_Id;
    }
    private String m_signal_name;
    @Override
    public String getSignal_name() throws XtumlException {
        checkLiving();
        return m_signal_name;
    }
    @Override
    public void setSignal_name(String m_signal_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_signal_name, this.m_signal_name)) {
            final String oldValue = this.m_signal_name;
            this.m_signal_name = m_signal_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_signal_name", oldValue, this.m_signal_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SEMEvent R526_is_a_SEMEvent_inst;
    @Override
    public void setR526_is_a_SEMEvent( SEMEvent inst ) {
        R526_is_a_SEMEvent_inst = inst;
    }
    @Override
    public SEMEvent R526_is_a_SEMEvent() throws XtumlException {
        return R526_is_a_SEMEvent_inst;
    }
    private ProvidedSignal R528_ProvidedSignal_inst;
    @Override
    public void setR528_ProvidedSignal( ProvidedSignal inst ) {
        R528_ProvidedSignal_inst = inst;
    }
    @Override
    public ProvidedSignal R528_ProvidedSignal() throws XtumlException {
        return R528_ProvidedSignal_inst;
    }
    private RequiredSignal R529_RequiredSignal_inst;
    @Override
    public void setR529_RequiredSignal( RequiredSignal inst ) {
        R529_RequiredSignal_inst = inst;
    }
    @Override
    public RequiredSignal R529_RequiredSignal() throws XtumlException {
        return R529_RequiredSignal_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SignalEvent self() {
        return this;
    }

    @Override
    public SignalEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SIGNALEVENT;
    }

}

class EmptySignalEvent extends ModelInstance<SignalEvent,Sql> implements SignalEvent {

    // attributes
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getProvided_Signal_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setProvided_Signal_Id( UniqueId ref_Provided_Signal_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRequired_Signal_Id( UniqueId ref_Required_Signal_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRequired_Signal_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSignal_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSignal_name( String m_signal_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SEMEvent R526_is_a_SEMEvent() {
        return SEMEventImpl.EMPTY_SEMEVENT;
    }
    @Override
    public ProvidedSignal R528_ProvidedSignal() {
        return ProvidedSignalImpl.EMPTY_PROVIDEDSIGNAL;
    }
    @Override
    public RequiredSignal R529_RequiredSignal() {
        return RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }


    @Override
    public String getKeyLetters() {
        return SignalEventImpl.KEY_LETTERS;
    }

    @Override
    public SignalEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SignalEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SignalEventImpl.EMPTY_SIGNALEVENT;
    }

}
