package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.ActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineState;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.ActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MooreStateMachineImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineStateImpl;


public class MooreActionHomeImpl extends ModelInstance<MooreActionHome,Sql> implements MooreActionHome {

    public static final String KEY_LETTERS = "SM_MOAH";
    public static final MooreActionHome EMPTY_MOOREACTIONHOME = new EmptyMooreActionHome();

    private Sql context;

    // constructors
    private MooreActionHomeImpl( Sql context ) {
        this.context = context;
        ref_Act_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMstt_ID = UniqueId.random();
        R511_MooreStateMachine_inst = MooreStateMachineImpl.EMPTY_MOORESTATEMACHINE;
        R511_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
        R513_is_a_ActionHome_inst = ActionHomeImpl.EMPTY_ACTIONHOME;
    }

    private MooreActionHomeImpl( Sql context, UniqueId instanceId, UniqueId ref_Act_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Act_ID = ref_Act_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMstt_ID = ref_SMstt_ID;
        R511_MooreStateMachine_inst = MooreStateMachineImpl.EMPTY_MOORESTATEMACHINE;
        R511_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
        R513_is_a_ActionHome_inst = ActionHomeImpl.EMPTY_ACTIONHOME;
    }

    public static MooreActionHome create( Sql context ) throws XtumlException {
        MooreActionHome newMooreActionHome = new MooreActionHomeImpl( context );
        if ( context.addInstance( newMooreActionHome ) ) {
            newMooreActionHome.getRunContext().addChange(new InstanceCreatedDelta(newMooreActionHome, KEY_LETTERS));
            return newMooreActionHome;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MooreActionHome create( Sql context, UniqueId instanceId, UniqueId ref_Act_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID ) throws XtumlException {
        MooreActionHome newMooreActionHome = new MooreActionHomeImpl( context, instanceId, ref_Act_ID, ref_SM_ID, ref_SMstt_ID );
        if ( context.addInstance( newMooreActionHome ) ) {
            return newMooreActionHome;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Act_ID;
    @Override
    public void setAct_ID(UniqueId ref_Act_ID) throws XtumlException {
        checkLiving();
        if (ref_Act_ID.inequality( this.ref_Act_ID)) {
            final UniqueId oldValue = this.ref_Act_ID;
            this.ref_Act_ID = ref_Act_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Act_ID", oldValue, this.ref_Act_ID));
        }
    }
    @Override
    public UniqueId getAct_ID() throws XtumlException {
        checkLiving();
        return ref_Act_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    private UniqueId ref_SMstt_ID;
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
        return ref_SMstt_ID;
    }
    @Override
    public void setSMstt_ID(UniqueId ref_SMstt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMstt_ID.inequality( this.ref_SMstt_ID)) {
            final UniqueId oldValue = this.ref_SMstt_ID;
            this.ref_SMstt_ID = ref_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMstt_ID", oldValue, this.ref_SMstt_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSM_ID(), getSMstt_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getAct_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MooreStateMachine R511_MooreStateMachine_inst;
    @Override
    public void setR511_MooreStateMachine( MooreStateMachine inst ) {
        R511_MooreStateMachine_inst = inst;
    }
    @Override
    public MooreStateMachine R511_MooreStateMachine() throws XtumlException {
        return R511_MooreStateMachine_inst;
    }
    private StateMachineState R511_StateMachineState_inst;
    @Override
    public void setR511_StateMachineState( StateMachineState inst ) {
        R511_StateMachineState_inst = inst;
    }
    @Override
    public StateMachineState R511_StateMachineState() throws XtumlException {
        return R511_StateMachineState_inst;
    }
    private ActionHome R513_is_a_ActionHome_inst;
    @Override
    public void setR513_is_a_ActionHome( ActionHome inst ) {
        R513_is_a_ActionHome_inst = inst;
    }
    @Override
    public ActionHome R513_is_a_ActionHome() throws XtumlException {
        return R513_is_a_ActionHome_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MooreActionHome self() {
        return this;
    }

    @Override
    public MooreActionHome oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MOOREACTIONHOME;
    }

}

class EmptyMooreActionHome extends ModelInstance<MooreActionHome,Sql> implements MooreActionHome {

    // attributes
    public void setAct_ID( UniqueId ref_Act_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAct_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MooreStateMachine R511_MooreStateMachine() {
        return MooreStateMachineImpl.EMPTY_MOORESTATEMACHINE;
    }
    @Override
    public StateMachineState R511_StateMachineState() {
        return StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }
    @Override
    public ActionHome R513_is_a_ActionHome() {
        return ActionHomeImpl.EMPTY_ACTIONHOME;
    }


    @Override
    public String getKeyLetters() {
        return MooreActionHomeImpl.KEY_LETTERS;
    }

    @Override
    public MooreActionHome self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MooreActionHome oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
    }

}
