package io.ciera.tool.sql.ooaofooa.selection.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.selection.ACT_SEL;
import io.ciera.tool.sql.ooaofooa.selection.SelectRelatedWhere;
import io.ciera.tool.sql.ooaofooa.selection.impl.ACT_SELImpl;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class SelectRelatedWhereImpl extends ModelInstance<SelectRelatedWhere,Sql> implements SelectRelatedWhere {

    public static final String KEY_LETTERS = "ACT_SRW";
    public static final SelectRelatedWhere EMPTY_SELECTRELATEDWHERE = new EmptySelectRelatedWhere();

    private Sql context;

    // constructors
    private SelectRelatedWhereImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Where_Clause_Value_ID = UniqueId.random();
        R611_where_clause_Value_inst = ValueImpl.EMPTY_VALUE;
        R664_is_a_ACT_SEL_inst = ACT_SELImpl.EMPTY_ACT_SEL;
    }

    private SelectRelatedWhereImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Where_Clause_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Where_Clause_Value_ID = ref_Where_Clause_Value_ID;
        R611_where_clause_Value_inst = ValueImpl.EMPTY_VALUE;
        R664_is_a_ACT_SEL_inst = ACT_SELImpl.EMPTY_ACT_SEL;
    }

    public static SelectRelatedWhere create( Sql context ) throws XtumlException {
        SelectRelatedWhere newSelectRelatedWhere = new SelectRelatedWhereImpl( context );
        if ( context.addInstance( newSelectRelatedWhere ) ) {
            newSelectRelatedWhere.getRunContext().addChange(new InstanceCreatedDelta(newSelectRelatedWhere, KEY_LETTERS));
            return newSelectRelatedWhere;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SelectRelatedWhere create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Where_Clause_Value_ID ) throws XtumlException {
        SelectRelatedWhere newSelectRelatedWhere = new SelectRelatedWhereImpl( context, instanceId, ref_Statement_ID, ref_Where_Clause_Value_ID );
        if ( context.addInstance( newSelectRelatedWhere ) ) {
            return newSelectRelatedWhere;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Where_Clause_Value_ID;
    @Override
    public UniqueId getWhere_Clause_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Where_Clause_Value_ID;
    }
    @Override
    public void setWhere_Clause_Value_ID(UniqueId ref_Where_Clause_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Where_Clause_Value_ID.inequality( this.ref_Where_Clause_Value_ID)) {
            final UniqueId oldValue = this.ref_Where_Clause_Value_ID;
            this.ref_Where_Clause_Value_ID = ref_Where_Clause_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Where_Clause_Value_ID", oldValue, this.ref_Where_Clause_Value_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R611_where_clause_Value_inst;
    @Override
    public void setR611_where_clause_Value( Value inst ) {
        R611_where_clause_Value_inst = inst;
    }
    @Override
    public Value R611_where_clause_Value() throws XtumlException {
        return R611_where_clause_Value_inst;
    }
    private ACT_SEL R664_is_a_ACT_SEL_inst;
    @Override
    public void setR664_is_a_ACT_SEL( ACT_SEL inst ) {
        R664_is_a_ACT_SEL_inst = inst;
    }
    @Override
    public ACT_SEL R664_is_a_ACT_SEL() throws XtumlException {
        return R664_is_a_ACT_SEL_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SelectRelatedWhere self() {
        return this;
    }

    @Override
    public SelectRelatedWhere oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SELECTRELATEDWHERE;
    }

}

class EmptySelectRelatedWhere extends ModelInstance<SelectRelatedWhere,Sql> implements SelectRelatedWhere {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getWhere_Clause_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setWhere_Clause_Value_ID( UniqueId ref_Where_Clause_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R611_where_clause_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public ACT_SEL R664_is_a_ACT_SEL() {
        return ACT_SELImpl.EMPTY_ACT_SEL;
    }


    @Override
    public String getKeyLetters() {
        return SelectRelatedWhereImpl.KEY_LETTERS;
    }

    @Override
    public SelectRelatedWhere self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SelectRelatedWhere oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SelectRelatedWhereImpl.EMPTY_SELECTRELATEDWHERE;
    }

}
