package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.InterfaceSignal;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceSignalImpl;
import io.ciera.tool.sql.ooaofooa.message.AsynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.SignalMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.AsynchronousMessageImpl;


public class SignalMessageImpl extends ModelInstance<SignalMessage,Sql> implements SignalMessage {

    public static final String KEY_LETTERS = "MSG_SIG";
    public static final SignalMessage EMPTY_SIGNALMESSAGE = new EmptySignalMessage();

    private Sql context;

    // constructors
    private SignalMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        ref_Id = UniqueId.random();
        R1019_is_a_AsynchronousMessage_inst = AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
        R1021_sends_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }

    private SignalMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.ref_Id = ref_Id;
        R1019_is_a_AsynchronousMessage_inst = AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
        R1021_sends_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }

    public static SignalMessage create( Sql context ) throws XtumlException {
        SignalMessage newSignalMessage = new SignalMessageImpl( context );
        if ( context.addInstance( newSignalMessage ) ) {
            newSignalMessage.getRunContext().addChange(new InstanceCreatedDelta(newSignalMessage, KEY_LETTERS));
            return newSignalMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SignalMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Id ) throws XtumlException {
        SignalMessage newSignalMessage = new SignalMessageImpl( context, instanceId, ref_Msg_ID, ref_Id );
        if ( context.addInstance( newSignalMessage ) ) {
            return newSignalMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private AsynchronousMessage R1019_is_a_AsynchronousMessage_inst;
    @Override
    public void setR1019_is_a_AsynchronousMessage( AsynchronousMessage inst ) {
        R1019_is_a_AsynchronousMessage_inst = inst;
    }
    @Override
    public AsynchronousMessage R1019_is_a_AsynchronousMessage() throws XtumlException {
        return R1019_is_a_AsynchronousMessage_inst;
    }
    private InterfaceSignal R1021_sends_InterfaceSignal_inst;
    @Override
    public void setR1021_sends_InterfaceSignal( InterfaceSignal inst ) {
        R1021_sends_InterfaceSignal_inst = inst;
    }
    @Override
    public InterfaceSignal R1021_sends_InterfaceSignal() throws XtumlException {
        return R1021_sends_InterfaceSignal_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SignalMessage self() {
        return this;
    }

    @Override
    public SignalMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SIGNALMESSAGE;
    }

}

class EmptySignalMessage extends ModelInstance<SignalMessage,Sql> implements SignalMessage {

    // attributes
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public AsynchronousMessage R1019_is_a_AsynchronousMessage() {
        return AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }
    @Override
    public InterfaceSignal R1021_sends_InterfaceSignal() {
        return InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }


    @Override
    public String getKeyLetters() {
        return SignalMessageImpl.KEY_LETTERS;
    }

    @Override
    public SignalMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SignalMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SignalMessageImpl.EMPTY_SIGNALMESSAGE;
    }

}
