package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;
import io.ciera.tool.sql.ooaofooa.interaction.ComponentParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantImpl;


public class ComponentParticipantImpl extends ModelInstance<ComponentParticipant,Sql> implements ComponentParticipant {

    public static final String KEY_LETTERS = "SQ_COP";
    public static final ComponentParticipant EMPTY_COMPONENTPARTICIPANT = new EmptyComponentParticipant();

    private Sql context;

    // constructors
    private ComponentParticipantImpl( Sql context ) {
        this.context = context;
        ref_Part_ID = UniqueId.random();
        ref_Component_Id = UniqueId.random();
        m_Label = "";
        m_InformalComponentName = "";
        m_Descrip = "";
        m_isFormal = false;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R955_represents_C_C_inst = C_CImpl.EMPTY_C_C;
    }

    private ComponentParticipantImpl( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Component_Id, String m_Label, String m_InformalComponentName, String m_Descrip, boolean m_isFormal ) {
        super(instanceId);
        this.context = context;
        this.ref_Part_ID = ref_Part_ID;
        this.ref_Component_Id = ref_Component_Id;
        this.m_Label = m_Label;
        this.m_InformalComponentName = m_InformalComponentName;
        this.m_Descrip = m_Descrip;
        this.m_isFormal = m_isFormal;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R955_represents_C_C_inst = C_CImpl.EMPTY_C_C;
    }

    public static ComponentParticipant create( Sql context ) throws XtumlException {
        ComponentParticipant newComponentParticipant = new ComponentParticipantImpl( context );
        if ( context.addInstance( newComponentParticipant ) ) {
            newComponentParticipant.getRunContext().addChange(new InstanceCreatedDelta(newComponentParticipant, KEY_LETTERS));
            return newComponentParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ComponentParticipant create( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Component_Id, String m_Label, String m_InformalComponentName, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        ComponentParticipant newComponentParticipant = new ComponentParticipantImpl( context, instanceId, ref_Part_ID, ref_Component_Id, m_Label, m_InformalComponentName, m_Descrip, m_isFormal );
        if ( context.addInstance( newComponentParticipant ) ) {
            return newComponentParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Part_ID;
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
        }
    }
    private UniqueId ref_Component_Id;
    @Override
    public UniqueId getComponent_Id() throws XtumlException {
        checkLiving();
        return ref_Component_Id;
    }
    @Override
    public void setComponent_Id(UniqueId ref_Component_Id) throws XtumlException {
        checkLiving();
        if (ref_Component_Id.inequality( this.ref_Component_Id)) {
            final UniqueId oldValue = this.ref_Component_Id;
            this.ref_Component_Id = ref_Component_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Component_Id", oldValue, this.ref_Component_Id));
        }
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    private String m_InformalComponentName;
    @Override
    public void setInformalComponentName(String m_InformalComponentName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalComponentName, this.m_InformalComponentName)) {
            final String oldValue = this.m_InformalComponentName;
            this.m_InformalComponentName = m_InformalComponentName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalComponentName", oldValue, this.m_InformalComponentName));
        }
    }
    @Override
    public String getInformalComponentName() throws XtumlException {
        checkLiving();
        return m_InformalComponentName;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private boolean m_isFormal;
    @Override
    public void setIsFormal(boolean m_isFormal) throws XtumlException {
        checkLiving();
        if (m_isFormal != this.m_isFormal) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
        return m_isFormal;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPart_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InteractionParticipant R930_is_a_InteractionParticipant_inst;
    @Override
    public void setR930_is_a_InteractionParticipant( InteractionParticipant inst ) {
        R930_is_a_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() throws XtumlException {
        return R930_is_a_InteractionParticipant_inst;
    }
    private C_C R955_represents_C_C_inst;
    @Override
    public void setR955_represents_C_C( C_C inst ) {
        R955_represents_C_C_inst = inst;
    }
    @Override
    public C_C R955_represents_C_C() throws XtumlException {
        return R955_represents_C_C_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ComponentParticipant self() {
        return this;
    }

    @Override
    public ComponentParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_COMPONENTPARTICIPANT;
    }

}

class EmptyComponentParticipant extends ModelInstance<ComponentParticipant,Sql> implements ComponentParticipant {

    // attributes
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getComponent_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComponent_Id( UniqueId ref_Component_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalComponentName( String m_InformalComponentName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInformalComponentName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public C_C R955_represents_C_C() {
        return C_CImpl.EMPTY_C_C;
    }


    @Override
    public String getKeyLetters() {
        return ComponentParticipantImpl.KEY_LETTERS;
    }

    @Override
    public ComponentParticipant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ComponentParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ComponentParticipantImpl.EMPTY_COMPONENTPARTICIPANT;
    }

}
