package io.ciera.tool.sql.ooaofooa.globals.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.SystemModel;
import io.ciera.tool.sql.ooaofooa.domain.impl.SystemModelImpl;
import io.ciera.tool.sql.ooaofooa.globals.GlobalElementInSystem;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class GlobalElementInSystemImpl extends ModelInstance<GlobalElementInSystem,Sql> implements GlobalElementInSystem {

    public static final String KEY_LETTERS = "G_EIS";
    public static final GlobalElementInSystem EMPTY_GLOBALELEMENTINSYSTEM = new EmptyGlobalElementInSystem();

    private Sql context;

    // constructors
    private GlobalElementInSystemImpl( Sql context ) {
        this.context = context;
        ref_Element_ID = UniqueId.random();
        ref_Sys_ID = UniqueId.random();
        R9100_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R9100_SystemModel_inst = SystemModelImpl.EMPTY_SYSTEMMODEL;
    }

    private GlobalElementInSystemImpl( Sql context, UniqueId instanceId, UniqueId ref_Element_ID, UniqueId ref_Sys_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Element_ID = ref_Element_ID;
        this.ref_Sys_ID = ref_Sys_ID;
        R9100_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R9100_SystemModel_inst = SystemModelImpl.EMPTY_SYSTEMMODEL;
    }

    public static GlobalElementInSystem create( Sql context ) throws XtumlException {
        GlobalElementInSystem newGlobalElementInSystem = new GlobalElementInSystemImpl( context );
        if ( context.addInstance( newGlobalElementInSystem ) ) {
            newGlobalElementInSystem.getRunContext().addChange(new InstanceCreatedDelta(newGlobalElementInSystem, KEY_LETTERS));
            return newGlobalElementInSystem;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GlobalElementInSystem create( Sql context, UniqueId instanceId, UniqueId ref_Element_ID, UniqueId ref_Sys_ID ) throws XtumlException {
        GlobalElementInSystem newGlobalElementInSystem = new GlobalElementInSystemImpl( context, instanceId, ref_Element_ID, ref_Sys_ID );
        if ( context.addInstance( newGlobalElementInSystem ) ) {
            return newGlobalElementInSystem;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Element_ID;
    @Override
    public UniqueId getElement_ID() throws XtumlException {
        checkLiving();
        return ref_Element_ID;
    }
    @Override
    public void setElement_ID(UniqueId ref_Element_ID) throws XtumlException {
        checkLiving();
        if (ref_Element_ID.inequality( this.ref_Element_ID)) {
            final UniqueId oldValue = this.ref_Element_ID;
            this.ref_Element_ID = ref_Element_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Element_ID", oldValue, this.ref_Element_ID));
        }
    }
    private UniqueId ref_Sys_ID;
    @Override
    public void setSys_ID(UniqueId ref_Sys_ID) throws XtumlException {
        checkLiving();
        if (ref_Sys_ID.inequality( this.ref_Sys_ID)) {
            final UniqueId oldValue = this.ref_Sys_ID;
            this.ref_Sys_ID = ref_Sys_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Sys_ID", oldValue, this.ref_Sys_ID));
        }
    }
    @Override
    public UniqueId getSys_ID() throws XtumlException {
        checkLiving();
        return ref_Sys_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getElement_ID(), getSys_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private PackageableElement R9100_PackageableElement_inst;
    @Override
    public void setR9100_PackageableElement( PackageableElement inst ) {
        R9100_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R9100_PackageableElement() throws XtumlException {
        return R9100_PackageableElement_inst;
    }
    private SystemModel R9100_SystemModel_inst;
    @Override
    public void setR9100_SystemModel( SystemModel inst ) {
        R9100_SystemModel_inst = inst;
    }
    @Override
    public SystemModel R9100_SystemModel() throws XtumlException {
        return R9100_SystemModel_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GlobalElementInSystem self() {
        return this;
    }

    @Override
    public GlobalElementInSystem oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_GLOBALELEMENTINSYSTEM;
    }

}

class EmptyGlobalElementInSystem extends ModelInstance<GlobalElementInSystem,Sql> implements GlobalElementInSystem {

    // attributes
    public UniqueId getElement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setElement_ID( UniqueId ref_Element_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSys_ID( UniqueId ref_Sys_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSys_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public PackageableElement R9100_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public SystemModel R9100_SystemModel() {
        return SystemModelImpl.EMPTY_SYSTEMMODEL;
    }


    @Override
    public String getKeyLetters() {
        return GlobalElementInSystemImpl.KEY_LETTERS;
    }

    @Override
    public GlobalElementInSystem self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GlobalElementInSystem oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return GlobalElementInSystemImpl.EMPTY_GLOBALELEMENTINSYSTEM;
    }

}
