package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.StructureMember;
import io.ciera.tool.sql.ooaofooa.domain.StructureMemberSet;
import io.ciera.tool.sql.ooaofooa.domain.StructuredDataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructureMemberSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructuredDataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.value.MemberValueReferenceSet;
import io.ciera.tool.sql.ooaofooa.value.impl.MemberValueReferenceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class StructureMemberSetImpl extends InstanceSet<StructureMemberSet,StructureMember> implements StructureMemberSet {

    public StructureMemberSetImpl() {
    }

    public StructureMemberSetImpl(Comparator<? super StructureMember> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setDescrip( m_Descrip );
    }
    @Override
    public void setParent_DT_DT_ID( UniqueId ref_Parent_DT_DT_ID ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setParent_DT_DT_ID( ref_Parent_DT_DT_ID );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setName( m_Name );
    }
    @Override
    public void setMember_ID( UniqueId m_Member_ID ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setMember_ID( m_Member_ID );
    }
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setDT_ID( ref_DT_ID );
    }
    @Override
    public void setPrevious_Member_ID( UniqueId ref_Previous_Member_ID ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setPrevious_Member_ID( ref_Previous_Member_ID );
    }
    @Override
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        for ( StructureMember structuremember : this ) structuremember.setDimensions( m_Dimensions );
    }


    // selections
    @Override
    public StructuredDataTypeSet R44_has_parent_StructuredDataType() throws XtumlException {
        StructuredDataTypeSet structureddatatypeset = new StructuredDataTypeSetImpl();
        for ( StructureMember structuremember : this ) structureddatatypeset.add( structuremember.R44_has_parent_StructuredDataType() );
        return structureddatatypeset;
    }
    @Override
    public DataTypeSet R45_is_defined_by_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( StructureMember structuremember : this ) datatypeset.add( structuremember.R45_is_defined_by_DataType() );
        return datatypeset;
    }
    @Override
    public StructureMemberSet R46_precedes_StructureMember() throws XtumlException {
        StructureMemberSet structurememberset = new StructureMemberSetImpl();
        for ( StructureMember structuremember : this ) structurememberset.add( structuremember.R46_precedes_StructureMember() );
        return structurememberset;
    }
    @Override
    public StructureMemberSet R46_succeeds_StructureMember() throws XtumlException {
        StructureMemberSet structurememberset = new StructureMemberSetImpl();
        for ( StructureMember structuremember : this ) structurememberset.add( structuremember.R46_succeeds_StructureMember() );
        return structurememberset;
    }
    @Override
    public DimensionsSet R53_may_have_Dimensions() throws XtumlException {
        DimensionsSet dimensionsset = new DimensionsSetImpl();
        for ( StructureMember structuremember : this ) dimensionsset.addAll( structuremember.R53_may_have_Dimensions() );
        return dimensionsset;
    }
    @Override
    public MemberValueReferenceSet R836_MemberValueReference() throws XtumlException {
        MemberValueReferenceSet membervaluereferenceset = new MemberValueReferenceSetImpl();
        for ( StructureMember structuremember : this ) membervaluereferenceset.addAll( structuremember.R836_MemberValueReference() );
        return membervaluereferenceset;
    }


    @Override
    public StructureMember nullElement() {
        return StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
    }

    @Override
    public StructureMemberSet emptySet() {
      return new StructureMemberSetImpl();
    }

    @Override
    public StructureMemberSet emptySet(Comparator<? super StructureMember> comp) {
      return new StructureMemberSetImpl(comp);
    }

    @Override
    public List<StructureMember> elements() {
        StructureMember[] elements = toArray(new StructureMember[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
