package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.BridgeSet;
import io.ciera.tool.sql.ooaofooa.domain.ExternalEntity;
import io.ciera.tool.sql.ooaofooa.domain.ExternalEntityInModel;
import io.ciera.tool.sql.ooaofooa.domain.ExternalEntityInModelSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.ExternalEntityInModelSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.ExternalEntityParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ExternalEntityParticipantSet;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ExternalEntityParticipantSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class ExternalEntityImpl extends ModelInstance<ExternalEntity,Sql> implements ExternalEntity {

    public static final String KEY_LETTERS = "S_EE";
    public static final ExternalEntity EMPTY_EXTERNALENTITY = new EmptyExternalEntity();

    private Sql context;

    // constructors
    private ExternalEntityImpl( Sql context ) {
        this.context = context;
        ref_EE_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Key_Lett = "";
        m_Dom_IDdeprecated = UniqueId.random();
        m_Realized_Class_Path = "";
        m_Label = "";
        m_isRealized = false;
        R19_uses_Bridge_set = new BridgeSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R933_represents_participant_of_ExternalEntityParticipant_set = new ExternalEntityParticipantSetImpl();
        R9_is_represented_by_ExternalEntityInModel_set = new ExternalEntityInModelSetImpl();
    }

    private ExternalEntityImpl( Sql context, UniqueId instanceId, UniqueId ref_EE_ID, String m_Name, String m_Descrip, String m_Key_Lett, UniqueId m_Dom_IDdeprecated, String m_Realized_Class_Path, String m_Label, boolean m_isRealized ) {
        super(instanceId);
        this.context = context;
        this.ref_EE_ID = ref_EE_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Key_Lett = m_Key_Lett;
        this.m_Dom_IDdeprecated = m_Dom_IDdeprecated;
        this.m_Realized_Class_Path = m_Realized_Class_Path;
        this.m_Label = m_Label;
        this.m_isRealized = m_isRealized;
        R19_uses_Bridge_set = new BridgeSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R933_represents_participant_of_ExternalEntityParticipant_set = new ExternalEntityParticipantSetImpl();
        R9_is_represented_by_ExternalEntityInModel_set = new ExternalEntityInModelSetImpl();
    }

    public static ExternalEntity create( Sql context ) throws XtumlException {
        ExternalEntity newExternalEntity = new ExternalEntityImpl( context );
        if ( context.addInstance( newExternalEntity ) ) {
            newExternalEntity.getRunContext().addChange(new InstanceCreatedDelta(newExternalEntity, KEY_LETTERS));
            return newExternalEntity;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ExternalEntity create( Sql context, UniqueId instanceId, UniqueId ref_EE_ID, String m_Name, String m_Descrip, String m_Key_Lett, UniqueId m_Dom_IDdeprecated, String m_Realized_Class_Path, String m_Label, boolean m_isRealized ) throws XtumlException {
        ExternalEntity newExternalEntity = new ExternalEntityImpl( context, instanceId, ref_EE_ID, m_Name, m_Descrip, m_Key_Lett, m_Dom_IDdeprecated, m_Realized_Class_Path, m_Label, m_isRealized );
        if ( context.addInstance( newExternalEntity ) ) {
            return newExternalEntity;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_EE_ID;
    @Override
    public void setEE_ID(UniqueId ref_EE_ID) throws XtumlException {
        checkLiving();
        if (ref_EE_ID.inequality( this.ref_EE_ID)) {
            final UniqueId oldValue = this.ref_EE_ID;
            this.ref_EE_ID = ref_EE_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_EE_ID", oldValue, this.ref_EE_ID));
            if ( !R9_is_represented_by_ExternalEntityInModel().isEmpty() ) R9_is_represented_by_ExternalEntityInModel().setEE_ID( ref_EE_ID );
            if ( !R19_uses_Bridge().isEmpty() ) R19_uses_Bridge().setEE_ID( ref_EE_ID );
            if ( !R933_represents_participant_of_ExternalEntityParticipant().isEmpty() ) R933_represents_participant_of_ExternalEntityParticipant().setEE_ID( ref_EE_ID );
        }
    }
    @Override
    public UniqueId getEE_ID() throws XtumlException {
        checkLiving();
        return ref_EE_ID;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private String m_Key_Lett;
    @Override
    public String getKey_Lett() throws XtumlException {
        checkLiving();
        return m_Key_Lett;
    }
    @Override
    public void setKey_Lett(String m_Key_Lett) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Key_Lett, this.m_Key_Lett)) {
            final String oldValue = this.m_Key_Lett;
            this.m_Key_Lett = m_Key_Lett;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Key_Lett", oldValue, this.m_Key_Lett));
        }
    }
    private UniqueId m_Dom_IDdeprecated;
    @Override
    public void setDom_IDdeprecated(UniqueId m_Dom_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_Dom_IDdeprecated.inequality( this.m_Dom_IDdeprecated)) {
            final UniqueId oldValue = this.m_Dom_IDdeprecated;
            this.m_Dom_IDdeprecated = m_Dom_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dom_IDdeprecated", oldValue, this.m_Dom_IDdeprecated));
        }
    }
    @Override
    public UniqueId getDom_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_Dom_IDdeprecated;
    }
    private String m_Realized_Class_Path;
    @Override
    public String getRealized_Class_Path() throws XtumlException {
        checkLiving();
        return m_Realized_Class_Path;
    }
    @Override
    public void setRealized_Class_Path(String m_Realized_Class_Path) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Realized_Class_Path, this.m_Realized_Class_Path)) {
            final String oldValue = this.m_Realized_Class_Path;
            this.m_Realized_Class_Path = m_Realized_Class_Path;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Realized_Class_Path", oldValue, this.m_Realized_Class_Path));
        }
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    private boolean m_isRealized;
    @Override
    public void setIsRealized(boolean m_isRealized) throws XtumlException {
        checkLiving();
        if (m_isRealized != this.m_isRealized) {
            final boolean oldValue = this.m_isRealized;
            this.m_isRealized = m_isRealized;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isRealized", oldValue, this.m_isRealized));
        }
    }
    @Override
    public boolean getIsRealized() throws XtumlException {
        checkLiving();
        return m_isRealized;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getEE_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private BridgeSet R19_uses_Bridge_set;
    @Override
    public void addR19_uses_Bridge( Bridge inst ) {
        R19_uses_Bridge_set.add(inst);
    }
    @Override
    public void removeR19_uses_Bridge( Bridge inst ) {
        R19_uses_Bridge_set.remove(inst);
    }
    @Override
    public BridgeSet R19_uses_Bridge() throws XtumlException {
        return R19_uses_Bridge_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }
    private ExternalEntityParticipantSet R933_represents_participant_of_ExternalEntityParticipant_set;
    @Override
    public void addR933_represents_participant_of_ExternalEntityParticipant( ExternalEntityParticipant inst ) {
        R933_represents_participant_of_ExternalEntityParticipant_set.add(inst);
    }
    @Override
    public void removeR933_represents_participant_of_ExternalEntityParticipant( ExternalEntityParticipant inst ) {
        R933_represents_participant_of_ExternalEntityParticipant_set.remove(inst);
    }
    @Override
    public ExternalEntityParticipantSet R933_represents_participant_of_ExternalEntityParticipant() throws XtumlException {
        return R933_represents_participant_of_ExternalEntityParticipant_set;
    }
    private ExternalEntityInModelSet R9_is_represented_by_ExternalEntityInModel_set;
    @Override
    public void addR9_is_represented_by_ExternalEntityInModel( ExternalEntityInModel inst ) {
        R9_is_represented_by_ExternalEntityInModel_set.add(inst);
    }
    @Override
    public void removeR9_is_represented_by_ExternalEntityInModel( ExternalEntityInModel inst ) {
        R9_is_represented_by_ExternalEntityInModel_set.remove(inst);
    }
    @Override
    public ExternalEntityInModelSet R9_is_represented_by_ExternalEntityInModel() throws XtumlException {
        return R9_is_represented_by_ExternalEntityInModel_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ExternalEntity self() {
        return this;
    }

    @Override
    public ExternalEntity oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EXTERNALENTITY;
    }

}

class EmptyExternalEntity extends ModelInstance<ExternalEntity,Sql> implements ExternalEntity {

    // attributes
    public void setEE_ID( UniqueId ref_EE_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getEE_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getKey_Lett() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setKey_Lett( String m_Key_Lett ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDom_IDdeprecated( UniqueId m_Dom_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDom_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRealized_Class_Path() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRealized_Class_Path( String m_Realized_Class_Path ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsRealized( boolean m_isRealized ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsRealized() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public BridgeSet R19_uses_Bridge() {
        return (new BridgeSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public ExternalEntityParticipantSet R933_represents_participant_of_ExternalEntityParticipant() {
        return (new ExternalEntityParticipantSetImpl());
    }
    @Override
    public ExternalEntityInModelSet R9_is_represented_by_ExternalEntityInModel() {
        return (new ExternalEntityInModelSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ExternalEntityImpl.KEY_LETTERS;
    }

    @Override
    public ExternalEntity self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ExternalEntity oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ExternalEntityImpl.EMPTY_EXTERNALENTITY;
    }

}
