package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.EnumerationDataType;
import io.ciera.tool.sql.ooaofooa.domain.EnumerationDataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.S_ENUMSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_ENUMSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class EnumerationDataTypeSetImpl extends InstanceSet<EnumerationDataTypeSet,EnumerationDataType> implements EnumerationDataTypeSet {

    public EnumerationDataTypeSetImpl() {
    }

    public EnumerationDataTypeSetImpl(Comparator<? super EnumerationDataType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( EnumerationDataType enumerationdatatype : this ) enumerationdatatype.setDT_ID( ref_DT_ID );
    }


    // selections
    @Override
    public DataTypeSet R17_is_a_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( EnumerationDataType enumerationdatatype : this ) datatypeset.add( enumerationdatatype.R17_is_a_DataType() );
        return datatypeset;
    }
    @Override
    public S_ENUMSet R27_defines_S_ENUM() throws XtumlException {
        S_ENUMSet s_enumset = new S_ENUMSetImpl();
        for ( EnumerationDataType enumerationdatatype : this ) s_enumset.addAll( enumerationdatatype.R27_defines_S_ENUM() );
        return s_enumset;
    }


    @Override
    public EnumerationDataType nullElement() {
        return EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
    }

    @Override
    public EnumerationDataTypeSet emptySet() {
      return new EnumerationDataTypeSetImpl();
    }

    @Override
    public EnumerationDataTypeSet emptySet(Comparator<? super EnumerationDataType> comp) {
      return new EnumerationDataTypeSetImpl(comp);
    }

    @Override
    public List<EnumerationDataType> elements() {
        return Arrays.asList(toArray(new EnumerationDataType[0]));
    }

}
