package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.ExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperationSet;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertySetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceOperationSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.message.InterfaceOperationMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.InterfaceOperationMessageSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import ooaofooa.datatypes.IFDirectionType;


public class InterfaceOperationSetImpl extends InstanceSet<InterfaceOperationSet,InterfaceOperation> implements InterfaceOperationSet {

    public InterfaceOperationSetImpl() {
    }

    public InterfaceOperationSetImpl(Comparator<? super InterfaceOperation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDirection( IFDirectionType m_Direction ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setDirection( m_Direction );
    }
    @Override
    public void setReturn_Dimensions( String m_Return_Dimensions ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setReturn_Dimensions( m_Return_Dimensions );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setDescrip( m_Descrip );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setName( m_Name );
    }
    @Override
    public void setPrevious_Id( UniqueId ref_Previous_Id ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setPrevious_Id( ref_Previous_Id );
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setId( ref_Id );
    }
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperation.setDT_ID( ref_DT_ID );
    }


    // selections
    @Override
    public InterfaceOperationMessageSet R1022_sent_by_InterfaceOperationMessage() throws XtumlException {
        InterfaceOperationMessageSet interfaceoperationmessageset = new InterfaceOperationMessageSetImpl();
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperationmessageset.addAll( interfaceoperation.R1022_sent_by_InterfaceOperationMessage() );
        return interfaceoperationmessageset;
    }
    @Override
    public ExecutablePropertySet R4004_is_a_ExecutableProperty() throws XtumlException {
        ExecutablePropertySet executablepropertyset = new ExecutablePropertySetImpl();
        for ( InterfaceOperation interfaceoperation : this ) executablepropertyset.add( interfaceoperation.R4004_is_a_ExecutableProperty() );
        return executablepropertyset;
    }
    @Override
    public DataTypeSet R4008_has_return_defined_by_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( InterfaceOperation interfaceoperation : this ) datatypeset.add( interfaceoperation.R4008_has_return_defined_by_DataType() );
        return datatypeset;
    }
    @Override
    public DimensionsSet R4018_return_value_may_have_Dimensions() throws XtumlException {
        DimensionsSet dimensionsset = new DimensionsSetImpl();
        for ( InterfaceOperation interfaceoperation : this ) dimensionsset.addAll( interfaceoperation.R4018_return_value_may_have_Dimensions() );
        return dimensionsset;
    }
    @Override
    public InterfaceOperationSet R4019_precedes_InterfaceOperation() throws XtumlException {
        InterfaceOperationSet interfaceoperationset = new InterfaceOperationSetImpl();
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperationset.add( interfaceoperation.R4019_precedes_InterfaceOperation() );
        return interfaceoperationset;
    }
    @Override
    public InterfaceOperationSet R4019_succeeds_InterfaceOperation() throws XtumlException {
        InterfaceOperationSet interfaceoperationset = new InterfaceOperationSetImpl();
        for ( InterfaceOperation interfaceoperation : this ) interfaceoperationset.add( interfaceoperation.R4019_succeeds_InterfaceOperation() );
        return interfaceoperationset;
    }


    @Override
    public InterfaceOperation nullElement() {
        return InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }

    @Override
    public InterfaceOperationSet emptySet() {
      return new InterfaceOperationSetImpl();
    }

    @Override
    public InterfaceOperationSet emptySet(Comparator<? super InterfaceOperation> comp) {
      return new InterfaceOperationSetImpl(comp);
    }

    @Override
    public List<InterfaceOperation> elements() {
        InterfaceOperation[] elements = toArray(new InterfaceOperation[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
