package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.ExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperation;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceOperationImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.message.InterfaceOperationMessage;
import io.ciera.tool.sql.ooaofooa.message.InterfaceOperationMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.InterfaceOperationMessageSetImpl;

import ooaofooa.datatypes.IFDirectionType;


public class InterfaceOperationImpl extends ModelInstance<InterfaceOperation,Sql> implements InterfaceOperation {

    public static final String KEY_LETTERS = "C_IO";
    public static final InterfaceOperation EMPTY_INTERFACEOPERATION = new EmptyInterfaceOperation();

    private Sql context;

    // constructors
    private InterfaceOperationImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        ref_DT_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Direction = IFDirectionType.UNINITIALIZED_ENUM;
        m_Return_Dimensions = "";
        ref_Previous_Id = UniqueId.random();
        R1022_sent_by_InterfaceOperationMessage_set = new InterfaceOperationMessageSetImpl();
        R4004_is_a_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4008_has_return_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R4018_return_value_may_have_Dimensions_set = new DimensionsSetImpl();
        R4019_precedes_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
        R4019_succeeds_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }

    private InterfaceOperationImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId ref_DT_ID, String m_Name, String m_Descrip, IFDirectionType m_Direction, String m_Return_Dimensions, UniqueId ref_Previous_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Direction = m_Direction;
        this.m_Return_Dimensions = m_Return_Dimensions;
        this.ref_Previous_Id = ref_Previous_Id;
        R1022_sent_by_InterfaceOperationMessage_set = new InterfaceOperationMessageSetImpl();
        R4004_is_a_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4008_has_return_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R4018_return_value_may_have_Dimensions_set = new DimensionsSetImpl();
        R4019_precedes_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
        R4019_succeeds_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }

    public static InterfaceOperation create( Sql context ) throws XtumlException {
        InterfaceOperation newInterfaceOperation = new InterfaceOperationImpl( context );
        if ( context.addInstance( newInterfaceOperation ) ) {
            newInterfaceOperation.getRunContext().addChange(new InstanceCreatedDelta(newInterfaceOperation, KEY_LETTERS));
            return newInterfaceOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InterfaceOperation create( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId ref_DT_ID, String m_Name, String m_Descrip, IFDirectionType m_Direction, String m_Return_Dimensions, UniqueId ref_Previous_Id ) throws XtumlException {
        InterfaceOperation newInterfaceOperation = new InterfaceOperationImpl( context, instanceId, ref_Id, ref_DT_ID, m_Name, m_Descrip, m_Direction, m_Return_Dimensions, ref_Previous_Id );
        if ( context.addInstance( newInterfaceOperation ) ) {
            return newInterfaceOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R1022_sent_by_InterfaceOperationMessage().isEmpty() ) R1022_sent_by_InterfaceOperationMessage().setId( ref_Id );
            if ( !R4019_precedes_InterfaceOperation().isEmpty() ) R4019_precedes_InterfaceOperation().setPrevious_Id( ref_Id );
            if ( !R4018_return_value_may_have_Dimensions().isEmpty() ) R4018_return_value_may_have_Dimensions().setId( ref_Id );
        }
    }
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private IFDirectionType m_Direction;
    @Override
    public void setDirection(IFDirectionType m_Direction) throws XtumlException {
        checkLiving();
        if (m_Direction.inequality( this.m_Direction)) {
            final IFDirectionType oldValue = this.m_Direction;
            this.m_Direction = m_Direction;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Direction", oldValue, this.m_Direction));
        }
    }
    @Override
    public IFDirectionType getDirection() throws XtumlException {
        checkLiving();
        return m_Direction;
    }
    private String m_Return_Dimensions;
    @Override
    public String getReturn_Dimensions() throws XtumlException {
        checkLiving();
        return m_Return_Dimensions;
    }
    @Override
    public void setReturn_Dimensions(String m_Return_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Return_Dimensions, this.m_Return_Dimensions)) {
            final String oldValue = this.m_Return_Dimensions;
            this.m_Return_Dimensions = m_Return_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Return_Dimensions", oldValue, this.m_Return_Dimensions));
        }
    }
    private UniqueId ref_Previous_Id;
    @Override
    public UniqueId getPrevious_Id() throws XtumlException {
        checkLiving();
        return ref_Previous_Id;
    }
    @Override
    public void setPrevious_Id(UniqueId ref_Previous_Id) throws XtumlException {
        checkLiving();
        if (ref_Previous_Id.inequality( this.ref_Previous_Id)) {
            final UniqueId oldValue = this.ref_Previous_Id;
            this.ref_Previous_Id = ref_Previous_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_Id", oldValue, this.ref_Previous_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InterfaceOperationMessageSet R1022_sent_by_InterfaceOperationMessage_set;
    @Override
    public void addR1022_sent_by_InterfaceOperationMessage( InterfaceOperationMessage inst ) {
        R1022_sent_by_InterfaceOperationMessage_set.add(inst);
    }
    @Override
    public void removeR1022_sent_by_InterfaceOperationMessage( InterfaceOperationMessage inst ) {
        R1022_sent_by_InterfaceOperationMessage_set.remove(inst);
    }
    @Override
    public InterfaceOperationMessageSet R1022_sent_by_InterfaceOperationMessage() throws XtumlException {
        return R1022_sent_by_InterfaceOperationMessage_set;
    }
    private ExecutableProperty R4004_is_a_ExecutableProperty_inst;
    @Override
    public void setR4004_is_a_ExecutableProperty( ExecutableProperty inst ) {
        R4004_is_a_ExecutableProperty_inst = inst;
    }
    @Override
    public ExecutableProperty R4004_is_a_ExecutableProperty() throws XtumlException {
        return R4004_is_a_ExecutableProperty_inst;
    }
    private DataType R4008_has_return_defined_by_DataType_inst;
    @Override
    public void setR4008_has_return_defined_by_DataType( DataType inst ) {
        R4008_has_return_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R4008_has_return_defined_by_DataType() throws XtumlException {
        return R4008_has_return_defined_by_DataType_inst;
    }
    private DimensionsSet R4018_return_value_may_have_Dimensions_set;
    @Override
    public void addR4018_return_value_may_have_Dimensions( Dimensions inst ) {
        R4018_return_value_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR4018_return_value_may_have_Dimensions( Dimensions inst ) {
        R4018_return_value_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R4018_return_value_may_have_Dimensions() throws XtumlException {
        return R4018_return_value_may_have_Dimensions_set;
    }
    private InterfaceOperation R4019_precedes_InterfaceOperation_inst;
    @Override
    public void setR4019_precedes_InterfaceOperation( InterfaceOperation inst ) {
        R4019_precedes_InterfaceOperation_inst = inst;
    }
    @Override
    public InterfaceOperation R4019_precedes_InterfaceOperation() throws XtumlException {
        return R4019_precedes_InterfaceOperation_inst;
    }
    private InterfaceOperation R4019_succeeds_InterfaceOperation_inst;
    @Override
    public void setR4019_succeeds_InterfaceOperation( InterfaceOperation inst ) {
        R4019_succeeds_InterfaceOperation_inst = inst;
    }
    @Override
    public InterfaceOperation R4019_succeeds_InterfaceOperation() throws XtumlException {
        return R4019_succeeds_InterfaceOperation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InterfaceOperation self() {
        return this;
    }

    @Override
    public InterfaceOperation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INTERFACEOPERATION;
    }

}

class EmptyInterfaceOperation extends ModelInstance<InterfaceOperation,Sql> implements InterfaceOperation {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDirection( IFDirectionType m_Direction ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public IFDirectionType getDirection() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReturn_Dimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReturn_Dimensions( String m_Return_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_Id( UniqueId ref_Previous_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InterfaceOperationMessageSet R1022_sent_by_InterfaceOperationMessage() {
        return (new InterfaceOperationMessageSetImpl());
    }
    @Override
    public ExecutableProperty R4004_is_a_ExecutableProperty() {
        return ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
    }
    @Override
    public DataType R4008_has_return_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R4018_return_value_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public InterfaceOperation R4019_precedes_InterfaceOperation() {
        return InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }
    @Override
    public InterfaceOperation R4019_succeeds_InterfaceOperation() {
        return InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }


    @Override
    public String getKeyLetters() {
        return InterfaceOperationImpl.KEY_LETTERS;
    }

    @Override
    public InterfaceOperation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InterfaceOperation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }

}
