package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Satisfaction;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedRequirement;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionImpl;


public class ImportedRequirementImpl extends ModelInstance<ImportedRequirement,Sql> implements ImportedRequirement {

    public static final String KEY_LETTERS = "CL_IR";
    public static final ImportedRequirement EMPTY_IMPORTEDREQUIREMENT = new EmptyImportedRequirement();

    private Sql context;

    // constructors
    private ImportedRequirementImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        ref_Satisfaction_Element_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R4703_is_a_ImportedReference_inst = ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
        R4706_provides_satisfaction_through_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
    }

    private ImportedRequirementImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId ref_Satisfaction_Element_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.ref_Satisfaction_Element_Id = ref_Satisfaction_Element_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R4703_is_a_ImportedReference_inst = ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
        R4706_provides_satisfaction_through_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
    }

    public static ImportedRequirement create( Sql context ) throws XtumlException {
        ImportedRequirement newImportedRequirement = new ImportedRequirementImpl( context );
        if ( context.addInstance( newImportedRequirement ) ) {
            newImportedRequirement.getRunContext().addChange(new InstanceCreatedDelta(newImportedRequirement, KEY_LETTERS));
            return newImportedRequirement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ImportedRequirement create( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId ref_Satisfaction_Element_Id, String m_Name, String m_Descrip ) throws XtumlException {
        ImportedRequirement newImportedRequirement = new ImportedRequirementImpl( context, instanceId, ref_Id, ref_Satisfaction_Element_Id, m_Name, m_Descrip );
        if ( context.addInstance( newImportedRequirement ) ) {
            return newImportedRequirement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private UniqueId ref_Satisfaction_Element_Id;
    @Override
    public void setSatisfaction_Element_Id(UniqueId ref_Satisfaction_Element_Id) throws XtumlException {
        checkLiving();
        if (ref_Satisfaction_Element_Id.inequality( this.ref_Satisfaction_Element_Id)) {
            final UniqueId oldValue = this.ref_Satisfaction_Element_Id;
            this.ref_Satisfaction_Element_Id = ref_Satisfaction_Element_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Satisfaction_Element_Id", oldValue, this.ref_Satisfaction_Element_Id));
        }
    }
    @Override
    public UniqueId getSatisfaction_Element_Id() throws XtumlException {
        checkLiving();
        return ref_Satisfaction_Element_Id;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ImportedReference R4703_is_a_ImportedReference_inst;
    @Override
    public void setR4703_is_a_ImportedReference( ImportedReference inst ) {
        R4703_is_a_ImportedReference_inst = inst;
    }
    @Override
    public ImportedReference R4703_is_a_ImportedReference() throws XtumlException {
        return R4703_is_a_ImportedReference_inst;
    }
    private Satisfaction R4706_provides_satisfaction_through_Satisfaction_inst;
    @Override
    public void setR4706_provides_satisfaction_through_Satisfaction( Satisfaction inst ) {
        R4706_provides_satisfaction_through_Satisfaction_inst = inst;
    }
    @Override
    public Satisfaction R4706_provides_satisfaction_through_Satisfaction() throws XtumlException {
        return R4706_provides_satisfaction_through_Satisfaction_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ImportedRequirement self() {
        return this;
    }

    @Override
    public ImportedRequirement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_IMPORTEDREQUIREMENT;
    }

}

class EmptyImportedRequirement extends ModelInstance<ImportedRequirement,Sql> implements ImportedRequirement {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSatisfaction_Element_Id( UniqueId ref_Satisfaction_Element_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSatisfaction_Element_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ImportedReference R4703_is_a_ImportedReference() {
        return ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
    }
    @Override
    public Satisfaction R4706_provides_satisfaction_through_Satisfaction() {
        return SatisfactionImpl.EMPTY_SATISFACTION;
    }


    @Override
    public String getKeyLetters() {
        return ImportedRequirementImpl.KEY_LETTERS;
    }

    @Override
    public ImportedRequirement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ImportedRequirement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
    }

}
