package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.DelegationSet;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedRequirementSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.PortReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedProvisionSetImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedRequirementSetImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.PortReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.DelegationSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ImportedReferenceSetImpl extends InstanceSet<ImportedReferenceSet,ImportedReference> implements ImportedReferenceSet {

    public ImportedReferenceSetImpl() {
    }

    public ImportedReferenceSetImpl(Comparator<? super ImportedReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setCL_POR_Id( UniqueId ref_CL_POR_Id ) throws XtumlException {
        for ( ImportedReference importedreference : this ) importedreference.setCL_POR_Id( ref_CL_POR_Id );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( ImportedReference importedreference : this ) importedreference.setName( m_Name );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( ImportedReference importedreference : this ) importedreference.setDescrip( m_Descrip );
    }
    @Override
    public void setRef_Id( UniqueId ref_Ref_Id ) throws XtumlException {
        for ( ImportedReference importedreference : this ) importedreference.setRef_Id( ref_Ref_Id );
    }
    @Override
    public void setId( UniqueId m_Id ) throws XtumlException {
        for ( ImportedReference importedreference : this ) importedreference.setId( m_Id );
    }
    @Override
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        for ( ImportedReference importedreference : this ) importedreference.setDelegation_Id( ref_Delegation_Id );
    }


    // selections
    @Override
    public InterfaceReferenceSet R4701_imports_InterfaceReference() throws XtumlException {
        InterfaceReferenceSet interfacereferenceset = new InterfaceReferenceSetImpl();
        for ( ImportedReference importedreference : this ) interfacereferenceset.add( importedreference.R4701_imports_InterfaceReference() );
        return interfacereferenceset;
    }
    @Override
    public ImportedProvisionSet R4703_is_a_ImportedProvision() throws XtumlException {
        ImportedProvisionSet importedprovisionset = new ImportedProvisionSetImpl();
        for ( ImportedReference importedreference : this ) importedprovisionset.add( importedreference.R4703_is_a_ImportedProvision() );
        return importedprovisionset;
    }
    @Override
    public ImportedRequirementSet R4703_is_a_ImportedRequirement() throws XtumlException {
        ImportedRequirementSet importedrequirementset = new ImportedRequirementSetImpl();
        for ( ImportedReference importedreference : this ) importedrequirementset.add( importedreference.R4703_is_a_ImportedRequirement() );
        return importedrequirementset;
    }
    @Override
    public DelegationSet R4704_accepts_communication_through_Delegation() throws XtumlException {
        DelegationSet delegationset = new DelegationSetImpl();
        for ( ImportedReference importedreference : this ) delegationset.add( importedreference.R4704_accepts_communication_through_Delegation() );
        return delegationset;
    }
    @Override
    public PortReferenceSet R4708_originates_from_PortReference() throws XtumlException {
        PortReferenceSet portreferenceset = new PortReferenceSetImpl();
        for ( ImportedReference importedreference : this ) portreferenceset.add( importedreference.R4708_originates_from_PortReference() );
        return portreferenceset;
    }


    @Override
    public ImportedReference nullElement() {
        return ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
    }

    @Override
    public ImportedReferenceSet emptySet() {
      return new ImportedReferenceSetImpl();
    }

    @Override
    public ImportedReferenceSet emptySet(Comparator<? super ImportedReference> comp) {
      return new ImportedReferenceSetImpl(comp);
    }

    @Override
    public List<ImportedReference> elements() {
        ImportedReference[] elements = toArray(new ImportedReference[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
