package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvision;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionInSatisfaction;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionInSatisfactionSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedProvisionInSatisfactionSetImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceImpl;


public class ImportedProvisionImpl extends ModelInstance<ImportedProvision,Sql> implements ImportedProvision {

    public static final String KEY_LETTERS = "CL_IP";
    public static final ImportedProvision EMPTY_IMPORTEDPROVISION = new EmptyImportedProvision();

    private Sql context;

    // constructors
    private ImportedProvisionImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R4703_is_a_ImportedReference_inst = ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
        R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction_set = new ImportedProvisionInSatisfactionSetImpl();
    }

    private ImportedProvisionImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R4703_is_a_ImportedReference_inst = ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
        R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction_set = new ImportedProvisionInSatisfactionSetImpl();
    }

    public static ImportedProvision create( Sql context ) throws XtumlException {
        ImportedProvision newImportedProvision = new ImportedProvisionImpl( context );
        if ( context.addInstance( newImportedProvision ) ) {
            newImportedProvision.getRunContext().addChange(new InstanceCreatedDelta(newImportedProvision, KEY_LETTERS));
            return newImportedProvision;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ImportedProvision create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        ImportedProvision newImportedProvision = new ImportedProvisionImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newImportedProvision ) ) {
            return newImportedProvision;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction().isEmpty() ) R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction().setImportedProvision_Id( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ImportedReference R4703_is_a_ImportedReference_inst;
    @Override
    public void setR4703_is_a_ImportedReference( ImportedReference inst ) {
        R4703_is_a_ImportedReference_inst = inst;
    }
    @Override
    public ImportedReference R4703_is_a_ImportedReference() throws XtumlException {
        return R4703_is_a_ImportedReference_inst;
    }
    private ImportedProvisionInSatisfactionSet R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction_set;
    @Override
    public void addR4705_provides_satisfaction_through_ImportedProvisionInSatisfaction( ImportedProvisionInSatisfaction inst ) {
        R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction_set.add(inst);
    }
    @Override
    public void removeR4705_provides_satisfaction_through_ImportedProvisionInSatisfaction( ImportedProvisionInSatisfaction inst ) {
        R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction_set.remove(inst);
    }
    @Override
    public ImportedProvisionInSatisfactionSet R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction() throws XtumlException {
        return R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ImportedProvision self() {
        return this;
    }

    @Override
    public ImportedProvision oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_IMPORTEDPROVISION;
    }

}

class EmptyImportedProvision extends ModelInstance<ImportedProvision,Sql> implements ImportedProvision {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ImportedReference R4703_is_a_ImportedReference() {
        return ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
    }
    @Override
    public ImportedProvisionInSatisfactionSet R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction() {
        return (new ImportedProvisionInSatisfactionSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ImportedProvisionImpl.KEY_LETTERS;
    }

    @Override
    public ImportedProvision self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ImportedProvision oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
    }

}
