package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.Block;
import io.ciera.tool.sql.ooaofooa.body.ElseStmt;
import io.ciera.tool.sql.ooaofooa.body.IfStmt;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.BlockImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.IfStmtImpl;


public class ElseStmtImpl extends ModelInstance<ElseStmt,Sql> implements ElseStmt {

    public static final String KEY_LETTERS = "ACT_E";
    public static final ElseStmt EMPTY_ELSESTMT = new EmptyElseStmt();

    private Sql context;

    // constructors
    private ElseStmtImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Block_ID = UniqueId.random();
        ref_If_Statement_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R606_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R683_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
        R692_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
    }

    private ElseStmtImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_If_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Block_ID = ref_Block_ID;
        this.ref_If_Statement_ID = ref_If_Statement_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R606_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R683_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
        R692_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
    }

    public static ElseStmt create( Sql context ) throws XtumlException {
        ElseStmt newElseStmt = new ElseStmtImpl( context );
        if ( context.addInstance( newElseStmt ) ) {
            newElseStmt.getRunContext().addChange(new InstanceCreatedDelta(newElseStmt, KEY_LETTERS));
            return newElseStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ElseStmt create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_If_Statement_ID ) throws XtumlException {
        ElseStmt newElseStmt = new ElseStmtImpl( context, instanceId, ref_Statement_ID, ref_Block_ID, ref_If_Statement_ID );
        if ( context.addInstance( newElseStmt ) ) {
            return newElseStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R692_IfStmt().isEmpty() ) R692_IfStmt().setElse_Statement_ID( ref_Statement_ID );
        }
    }
    private UniqueId ref_Block_ID;
    @Override
    public void setBlock_ID(UniqueId ref_Block_ID) throws XtumlException {
        checkLiving();
        if (ref_Block_ID.inequality( this.ref_Block_ID)) {
            final UniqueId oldValue = this.ref_Block_ID;
            this.ref_Block_ID = ref_Block_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Block_ID", oldValue, this.ref_Block_ID));
        }
    }
    @Override
    public UniqueId getBlock_ID() throws XtumlException {
        checkLiving();
        return ref_Block_ID;
    }
    private UniqueId ref_If_Statement_ID;
    @Override
    public UniqueId getIf_Statement_ID() throws XtumlException {
        checkLiving();
        return ref_If_Statement_ID;
    }
    @Override
    public void setIf_Statement_ID(UniqueId ref_If_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_If_Statement_ID.inequality( this.ref_If_Statement_ID)) {
            final UniqueId oldValue = this.ref_If_Statement_ID;
            this.ref_If_Statement_ID = ref_If_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_If_Statement_ID", oldValue, this.ref_If_Statement_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Block R606_controls_Block_inst;
    @Override
    public void setR606_controls_Block( Block inst ) {
        R606_controls_Block_inst = inst;
    }
    @Override
    public Block R606_controls_Block() throws XtumlException {
        return R606_controls_Block_inst;
    }
    private IfStmt R683_IfStmt_inst;
    @Override
    public void setR683_IfStmt( IfStmt inst ) {
        R683_IfStmt_inst = inst;
    }
    @Override
    public IfStmt R683_IfStmt() throws XtumlException {
        return R683_IfStmt_inst;
    }
    private IfStmt R692_IfStmt_inst;
    @Override
    public void setR692_IfStmt( IfStmt inst ) {
        R692_IfStmt_inst = inst;
    }
    @Override
    public IfStmt R692_IfStmt() throws XtumlException {
        return R692_IfStmt_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ElseStmt self() {
        return this;
    }

    @Override
    public ElseStmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ELSESTMT;
    }

}

class EmptyElseStmt extends ModelInstance<ElseStmt,Sql> implements ElseStmt {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBlock_ID( UniqueId ref_Block_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBlock_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getIf_Statement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIf_Statement_ID( UniqueId ref_If_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Block R606_controls_Block() {
        return BlockImpl.EMPTY_BLOCK;
    }
    @Override
    public IfStmt R683_IfStmt() {
        return IfStmtImpl.EMPTY_IFSTMT;
    }
    @Override
    public IfStmt R692_IfStmt() {
        return IfStmtImpl.EMPTY_IFSTMT;
    }


    @Override
    public String getKeyLetters() {
        return ElseStmtImpl.KEY_LETTERS;
    }

    @Override
    public ElseStmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ElseStmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ElseStmtImpl.EMPTY_ELSESTMT;
    }

}
