package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ClassAsLink;
import io.ciera.tool.sql.ooaofooa.association.LinkedAssociation;
import io.ciera.tool.sql.ooaofooa.association.ReferringClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.impl.LinkedAssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferringClassInAssocImpl;


public class ClassAsLinkImpl extends ModelInstance<ClassAsLink,Sql> implements ClassAsLink {

    public static final String KEY_LETTERS = "R_ASSR";
    public static final ClassAsLink EMPTY_CLASSASLINK = new EmptyClassAsLink();

    private Sql context;

    // constructors
    private ClassAsLinkImpl( Sql context ) {
        this.context = context;
        ref_Obj_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_OIR_ID = UniqueId.random();
        m_Mult = 0;
        R205_is_a_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
        R211_formalizes_association_between_associated_classes_LinkedAssociation_inst = LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
    }

    private ClassAsLinkImpl( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID, int m_Mult ) {
        super(instanceId);
        this.context = context;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_OIR_ID = ref_OIR_ID;
        this.m_Mult = m_Mult;
        R205_is_a_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
        R211_formalizes_association_between_associated_classes_LinkedAssociation_inst = LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
    }

    public static ClassAsLink create( Sql context ) throws XtumlException {
        ClassAsLink newClassAsLink = new ClassAsLinkImpl( context );
        if ( context.addInstance( newClassAsLink ) ) {
            newClassAsLink.getRunContext().addChange(new InstanceCreatedDelta(newClassAsLink, KEY_LETTERS));
            return newClassAsLink;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassAsLink create( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID, int m_Mult ) throws XtumlException {
        ClassAsLink newClassAsLink = new ClassAsLinkImpl( context, instanceId, ref_Obj_ID, ref_Rel_ID, ref_OIR_ID, m_Mult );
        if ( context.addInstance( newClassAsLink ) ) {
            return newClassAsLink;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }
    private UniqueId ref_OIR_ID;
    @Override
    public void setOIR_ID(UniqueId ref_OIR_ID) throws XtumlException {
        checkLiving();
        if (ref_OIR_ID.inequality( this.ref_OIR_ID)) {
            final UniqueId oldValue = this.ref_OIR_ID;
            this.ref_OIR_ID = ref_OIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_OIR_ID", oldValue, this.ref_OIR_ID));
        }
    }
    @Override
    public UniqueId getOIR_ID() throws XtumlException {
        checkLiving();
        return ref_OIR_ID;
    }
    private int m_Mult;
    @Override
    public int getMult() throws XtumlException {
        checkLiving();
        return m_Mult;
    }
    @Override
    public void setMult(int m_Mult) throws XtumlException {
        checkLiving();
        if (m_Mult != this.m_Mult) {
            final int oldValue = this.m_Mult;
            this.m_Mult = m_Mult;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Mult", oldValue, this.m_Mult));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getObj_ID(), getRel_ID(), getOIR_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ReferringClassInAssoc R205_is_a_ReferringClassInAssoc_inst;
    @Override
    public void setR205_is_a_ReferringClassInAssoc( ReferringClassInAssoc inst ) {
        R205_is_a_ReferringClassInAssoc_inst = inst;
    }
    @Override
    public ReferringClassInAssoc R205_is_a_ReferringClassInAssoc() throws XtumlException {
        return R205_is_a_ReferringClassInAssoc_inst;
    }
    private LinkedAssociation R211_formalizes_association_between_associated_classes_LinkedAssociation_inst;
    @Override
    public void setR211_formalizes_association_between_associated_classes_LinkedAssociation( LinkedAssociation inst ) {
        R211_formalizes_association_between_associated_classes_LinkedAssociation_inst = inst;
    }
    @Override
    public LinkedAssociation R211_formalizes_association_between_associated_classes_LinkedAssociation() throws XtumlException {
        return R211_formalizes_association_between_associated_classes_LinkedAssociation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassAsLink self() {
        return this;
    }

    @Override
    public ClassAsLink oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSASLINK;
    }

}

class EmptyClassAsLink extends ModelInstance<ClassAsLink,Sql> implements ClassAsLink {

    // attributes
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setOIR_ID( UniqueId ref_OIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getMult() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMult( int m_Mult ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ReferringClassInAssoc R205_is_a_ReferringClassInAssoc() {
        return ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
    }
    @Override
    public LinkedAssociation R211_formalizes_association_between_associated_classes_LinkedAssociation() {
        return LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return ClassAsLinkImpl.KEY_LETTERS;
    }

    @Override
    public ClassAsLink self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassAsLink oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassAsLinkImpl.EMPTY_CLASSASLINK;
    }

}
