package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociation;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociationSet;
import io.ciera.tool.sql.ooaofooa.association.DerivedAssociation;
import io.ciera.tool.sql.ooaofooa.association.LinkedAssociation;
import io.ciera.tool.sql.ooaofooa.association.SimpleAssociation;
import io.ciera.tool.sql.ooaofooa.association.SubtypeSupertypeAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassInAssociationSetImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.DerivedAssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.LinkedAssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.SimpleAssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.SubtypeSupertypeAssociationImpl;
import io.ciera.tool.sql.ooaofooa.communication.CommunicationLink;
import io.ciera.tool.sql.ooaofooa.communication.CommunicationLinkSet;
import io.ciera.tool.sql.ooaofooa.communication.impl.CommunicationLinkSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.Link;
import io.ciera.tool.sql.ooaofooa.instance.LinkParticipation;
import io.ciera.tool.sql.ooaofooa.instance.LinkParticipationSet;
import io.ciera.tool.sql.ooaofooa.instance.LinkSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.LinkParticipationSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.LinkSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.Relate;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.RelateSet;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.RelateUsing;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.RelateUsingSet;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.Unrelate;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.UnrelateSet;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.UnrelateUsing;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.UnrelateUsingSet;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.impl.RelateSetImpl;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.impl.RelateUsingSetImpl;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.impl.UnrelateSetImpl;
import io.ciera.tool.sql.ooaofooa.relateandunrelate.impl.UnrelateUsingSetImpl;
import io.ciera.tool.sql.ooaofooa.selection.ChainLink;
import io.ciera.tool.sql.ooaofooa.selection.ChainLinkSet;
import io.ciera.tool.sql.ooaofooa.selection.impl.ChainLinkSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.Deferral;
import io.ciera.tool.sql.ooaofooa.subsystem.DeferralSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.DeferralSetImpl;


public class AssociationImpl extends ModelInstance<Association,Sql> implements Association {

    public static final String KEY_LETTERS = "R_REL";
    public static final Association EMPTY_ASSOCIATION = new EmptyAssociation();

    private Sql context;

    // constructors
    private AssociationImpl( Sql context ) {
        this.context = context;
        ref_Rel_ID = UniqueId.random();
        m_Numb = 0;
        m_Descrip = "";
        m_SS_IDdeprecated = UniqueId.random();
        R1128_represents_formal_instance_CommunicationLink_set = new CommunicationLinkSetImpl();
        R126_delegates_execution_of_Deferral_set = new DeferralSetImpl();
        R201_abstracts_association_between_instances_of_ClassInAssociation_set = new ClassInAssociationSetImpl();
        R206_is_a_DerivedAssociation_inst = DerivedAssociationImpl.EMPTY_DERIVEDASSOCIATION;
        R206_is_a_LinkedAssociation_inst = LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
        R206_is_a_SimpleAssociation_inst = SimpleAssociationImpl.EMPTY_SIMPLEASSOCIATION;
        R206_is_a_SubtypeSupertypeAssociation_inst = SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
        R2904_has_instances_Link_set = new LinkSetImpl();
        R2959_LinkParticipation_set = new LinkParticipationSetImpl();
        R653_Relate_set = new RelateSetImpl();
        R654_RelateUsing_set = new RelateUsingSetImpl();
        R655_Unrelate_set = new UnrelateSetImpl();
        R656_UnrelateUsing_set = new UnrelateUsingSetImpl();
        R681_ChainLink_set = new ChainLinkSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private AssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID, int m_Numb, String m_Descrip, UniqueId m_SS_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Rel_ID = ref_Rel_ID;
        this.m_Numb = m_Numb;
        this.m_Descrip = m_Descrip;
        this.m_SS_IDdeprecated = m_SS_IDdeprecated;
        R1128_represents_formal_instance_CommunicationLink_set = new CommunicationLinkSetImpl();
        R126_delegates_execution_of_Deferral_set = new DeferralSetImpl();
        R201_abstracts_association_between_instances_of_ClassInAssociation_set = new ClassInAssociationSetImpl();
        R206_is_a_DerivedAssociation_inst = DerivedAssociationImpl.EMPTY_DERIVEDASSOCIATION;
        R206_is_a_LinkedAssociation_inst = LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
        R206_is_a_SimpleAssociation_inst = SimpleAssociationImpl.EMPTY_SIMPLEASSOCIATION;
        R206_is_a_SubtypeSupertypeAssociation_inst = SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
        R2904_has_instances_Link_set = new LinkSetImpl();
        R2959_LinkParticipation_set = new LinkParticipationSetImpl();
        R653_Relate_set = new RelateSetImpl();
        R654_RelateUsing_set = new RelateUsingSetImpl();
        R655_Unrelate_set = new UnrelateSetImpl();
        R656_UnrelateUsing_set = new UnrelateUsingSetImpl();
        R681_ChainLink_set = new ChainLinkSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static Association create( Sql context ) throws XtumlException {
        Association newAssociation = new AssociationImpl( context );
        if ( context.addInstance( newAssociation ) ) {
            newAssociation.getRunContext().addChange(new InstanceCreatedDelta(newAssociation, KEY_LETTERS));
            return newAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Association create( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID, int m_Numb, String m_Descrip, UniqueId m_SS_IDdeprecated ) throws XtumlException {
        Association newAssociation = new AssociationImpl( context, instanceId, ref_Rel_ID, m_Numb, m_Descrip, m_SS_IDdeprecated );
        if ( context.addInstance( newAssociation ) ) {
            return newAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R1128_represents_formal_instance_CommunicationLink().isEmpty() ) R1128_represents_formal_instance_CommunicationLink().setRel_ID( ref_Rel_ID );
            if ( !R681_ChainLink().isEmpty() ) R681_ChainLink().setRel_ID( ref_Rel_ID );
            if ( !R206_is_a_LinkedAssociation().isEmpty() ) R206_is_a_LinkedAssociation().setRel_ID( ref_Rel_ID );
            if ( !R2959_LinkParticipation().isEmpty() ) R2959_LinkParticipation().setRel_ID( ref_Rel_ID );
            if ( !R656_UnrelateUsing().isEmpty() ) R656_UnrelateUsing().setRel_ID( ref_Rel_ID );
            if ( !R201_abstracts_association_between_instances_of_ClassInAssociation().isEmpty() ) R201_abstracts_association_between_instances_of_ClassInAssociation().setRel_ID( ref_Rel_ID );
            if ( !R206_is_a_DerivedAssociation().isEmpty() ) R206_is_a_DerivedAssociation().setRel_ID( ref_Rel_ID );
            if ( !R206_is_a_SimpleAssociation().isEmpty() ) R206_is_a_SimpleAssociation().setRel_ID( ref_Rel_ID );
            if ( !R2904_has_instances_Link().isEmpty() ) R2904_has_instances_Link().setRel_ID( ref_Rel_ID );
            if ( !R655_Unrelate().isEmpty() ) R655_Unrelate().setRel_ID( ref_Rel_ID );
            if ( !R206_is_a_SubtypeSupertypeAssociation().isEmpty() ) R206_is_a_SubtypeSupertypeAssociation().setRel_ID( ref_Rel_ID );
            if ( !R126_delegates_execution_of_Deferral().isEmpty() ) R126_delegates_execution_of_Deferral().setRel_ID( ref_Rel_ID );
            if ( !R654_RelateUsing().isEmpty() ) R654_RelateUsing().setRel_ID( ref_Rel_ID );
            if ( !R653_Relate().isEmpty() ) R653_Relate().setRel_ID( ref_Rel_ID );
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    private int m_Numb;
    @Override
    public void setNumb(int m_Numb) throws XtumlException {
        checkLiving();
        if (m_Numb != this.m_Numb) {
            final int oldValue = this.m_Numb;
            this.m_Numb = m_Numb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Numb", oldValue, this.m_Numb));
        }
    }
    @Override
    public int getNumb() throws XtumlException {
        checkLiving();
        return m_Numb;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private UniqueId m_SS_IDdeprecated;
    @Override
    public void setSS_IDdeprecated(UniqueId m_SS_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SS_IDdeprecated.inequality( this.m_SS_IDdeprecated)) {
            final UniqueId oldValue = this.m_SS_IDdeprecated;
            this.m_SS_IDdeprecated = m_SS_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SS_IDdeprecated", oldValue, this.m_SS_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSS_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SS_IDdeprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private CommunicationLinkSet R1128_represents_formal_instance_CommunicationLink_set;
    @Override
    public void addR1128_represents_formal_instance_CommunicationLink( CommunicationLink inst ) {
        R1128_represents_formal_instance_CommunicationLink_set.add(inst);
    }
    @Override
    public void removeR1128_represents_formal_instance_CommunicationLink( CommunicationLink inst ) {
        R1128_represents_formal_instance_CommunicationLink_set.remove(inst);
    }
    @Override
    public CommunicationLinkSet R1128_represents_formal_instance_CommunicationLink() throws XtumlException {
        return R1128_represents_formal_instance_CommunicationLink_set;
    }
    private DeferralSet R126_delegates_execution_of_Deferral_set;
    @Override
    public void addR126_delegates_execution_of_Deferral( Deferral inst ) {
        R126_delegates_execution_of_Deferral_set.add(inst);
    }
    @Override
    public void removeR126_delegates_execution_of_Deferral( Deferral inst ) {
        R126_delegates_execution_of_Deferral_set.remove(inst);
    }
    @Override
    public DeferralSet R126_delegates_execution_of_Deferral() throws XtumlException {
        return R126_delegates_execution_of_Deferral_set;
    }
    private ClassInAssociationSet R201_abstracts_association_between_instances_of_ClassInAssociation_set;
    @Override
    public void addR201_abstracts_association_between_instances_of_ClassInAssociation( ClassInAssociation inst ) {
        R201_abstracts_association_between_instances_of_ClassInAssociation_set.add(inst);
    }
    @Override
    public void removeR201_abstracts_association_between_instances_of_ClassInAssociation( ClassInAssociation inst ) {
        R201_abstracts_association_between_instances_of_ClassInAssociation_set.remove(inst);
    }
    @Override
    public ClassInAssociationSet R201_abstracts_association_between_instances_of_ClassInAssociation() throws XtumlException {
        return R201_abstracts_association_between_instances_of_ClassInAssociation_set;
    }
    private DerivedAssociation R206_is_a_DerivedAssociation_inst;
    @Override
    public void setR206_is_a_DerivedAssociation( DerivedAssociation inst ) {
        R206_is_a_DerivedAssociation_inst = inst;
    }
    @Override
    public DerivedAssociation R206_is_a_DerivedAssociation() throws XtumlException {
        return R206_is_a_DerivedAssociation_inst;
    }
    private LinkedAssociation R206_is_a_LinkedAssociation_inst;
    @Override
    public void setR206_is_a_LinkedAssociation( LinkedAssociation inst ) {
        R206_is_a_LinkedAssociation_inst = inst;
    }
    @Override
    public LinkedAssociation R206_is_a_LinkedAssociation() throws XtumlException {
        return R206_is_a_LinkedAssociation_inst;
    }
    private SimpleAssociation R206_is_a_SimpleAssociation_inst;
    @Override
    public void setR206_is_a_SimpleAssociation( SimpleAssociation inst ) {
        R206_is_a_SimpleAssociation_inst = inst;
    }
    @Override
    public SimpleAssociation R206_is_a_SimpleAssociation() throws XtumlException {
        return R206_is_a_SimpleAssociation_inst;
    }
    private SubtypeSupertypeAssociation R206_is_a_SubtypeSupertypeAssociation_inst;
    @Override
    public void setR206_is_a_SubtypeSupertypeAssociation( SubtypeSupertypeAssociation inst ) {
        R206_is_a_SubtypeSupertypeAssociation_inst = inst;
    }
    @Override
    public SubtypeSupertypeAssociation R206_is_a_SubtypeSupertypeAssociation() throws XtumlException {
        return R206_is_a_SubtypeSupertypeAssociation_inst;
    }
    private LinkSet R2904_has_instances_Link_set;
    @Override
    public void addR2904_has_instances_Link( Link inst ) {
        R2904_has_instances_Link_set.add(inst);
    }
    @Override
    public void removeR2904_has_instances_Link( Link inst ) {
        R2904_has_instances_Link_set.remove(inst);
    }
    @Override
    public LinkSet R2904_has_instances_Link() throws XtumlException {
        return R2904_has_instances_Link_set;
    }
    private LinkParticipationSet R2959_LinkParticipation_set;
    @Override
    public void addR2959_LinkParticipation( LinkParticipation inst ) {
        R2959_LinkParticipation_set.add(inst);
    }
    @Override
    public void removeR2959_LinkParticipation( LinkParticipation inst ) {
        R2959_LinkParticipation_set.remove(inst);
    }
    @Override
    public LinkParticipationSet R2959_LinkParticipation() throws XtumlException {
        return R2959_LinkParticipation_set;
    }
    private RelateSet R653_Relate_set;
    @Override
    public void addR653_Relate( Relate inst ) {
        R653_Relate_set.add(inst);
    }
    @Override
    public void removeR653_Relate( Relate inst ) {
        R653_Relate_set.remove(inst);
    }
    @Override
    public RelateSet R653_Relate() throws XtumlException {
        return R653_Relate_set;
    }
    private RelateUsingSet R654_RelateUsing_set;
    @Override
    public void addR654_RelateUsing( RelateUsing inst ) {
        R654_RelateUsing_set.add(inst);
    }
    @Override
    public void removeR654_RelateUsing( RelateUsing inst ) {
        R654_RelateUsing_set.remove(inst);
    }
    @Override
    public RelateUsingSet R654_RelateUsing() throws XtumlException {
        return R654_RelateUsing_set;
    }
    private UnrelateSet R655_Unrelate_set;
    @Override
    public void addR655_Unrelate( Unrelate inst ) {
        R655_Unrelate_set.add(inst);
    }
    @Override
    public void removeR655_Unrelate( Unrelate inst ) {
        R655_Unrelate_set.remove(inst);
    }
    @Override
    public UnrelateSet R655_Unrelate() throws XtumlException {
        return R655_Unrelate_set;
    }
    private UnrelateUsingSet R656_UnrelateUsing_set;
    @Override
    public void addR656_UnrelateUsing( UnrelateUsing inst ) {
        R656_UnrelateUsing_set.add(inst);
    }
    @Override
    public void removeR656_UnrelateUsing( UnrelateUsing inst ) {
        R656_UnrelateUsing_set.remove(inst);
    }
    @Override
    public UnrelateUsingSet R656_UnrelateUsing() throws XtumlException {
        return R656_UnrelateUsing_set;
    }
    private ChainLinkSet R681_ChainLink_set;
    @Override
    public void addR681_ChainLink( ChainLink inst ) {
        R681_ChainLink_set.add(inst);
    }
    @Override
    public void removeR681_ChainLink( ChainLink inst ) {
        R681_ChainLink_set.remove(inst);
    }
    @Override
    public ChainLinkSet R681_ChainLink() throws XtumlException {
        return R681_ChainLink_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Association self() {
        return this;
    }

    @Override
    public Association oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ASSOCIATION;
    }

}

class EmptyAssociation extends ModelInstance<Association,Sql> implements Association {

    // attributes
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumb( int m_Numb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSS_IDdeprecated( UniqueId m_SS_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSS_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public CommunicationLinkSet R1128_represents_formal_instance_CommunicationLink() {
        return (new CommunicationLinkSetImpl());
    }
    @Override
    public DeferralSet R126_delegates_execution_of_Deferral() {
        return (new DeferralSetImpl());
    }
    @Override
    public ClassInAssociationSet R201_abstracts_association_between_instances_of_ClassInAssociation() {
        return (new ClassInAssociationSetImpl());
    }
    @Override
    public DerivedAssociation R206_is_a_DerivedAssociation() {
        return DerivedAssociationImpl.EMPTY_DERIVEDASSOCIATION;
    }
    @Override
    public LinkedAssociation R206_is_a_LinkedAssociation() {
        return LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
    }
    @Override
    public SimpleAssociation R206_is_a_SimpleAssociation() {
        return SimpleAssociationImpl.EMPTY_SIMPLEASSOCIATION;
    }
    @Override
    public SubtypeSupertypeAssociation R206_is_a_SubtypeSupertypeAssociation() {
        return SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }
    @Override
    public LinkSet R2904_has_instances_Link() {
        return (new LinkSetImpl());
    }
    @Override
    public LinkParticipationSet R2959_LinkParticipation() {
        return (new LinkParticipationSetImpl());
    }
    @Override
    public RelateSet R653_Relate() {
        return (new RelateSetImpl());
    }
    @Override
    public RelateUsingSet R654_RelateUsing() {
        return (new RelateUsingSetImpl());
    }
    @Override
    public UnrelateSet R655_Unrelate() {
        return (new UnrelateSetImpl());
    }
    @Override
    public UnrelateUsingSet R656_UnrelateUsing() {
        return (new UnrelateUsingSetImpl());
    }
    @Override
    public ChainLinkSet R681_ChainLink() {
        return (new ChainLinkSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return AssociationImpl.KEY_LETTERS;
    }

    @Override
    public Association self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Association oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AssociationImpl.EMPTY_ASSOCIATION;
    }

}
