package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.AcceptEvent;
import io.ciera.tool.sql.ooaofooa.activity.ActionNode;
import io.ciera.tool.sql.ooaofooa.activity.ActivityDiagramAction;
import io.ciera.tool.sql.ooaofooa.activity.ActivityNode;
import io.ciera.tool.sql.ooaofooa.activity.SendSignal;
import io.ciera.tool.sql.ooaofooa.activity.impl.AcceptEventImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityDiagramActionImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.SendSignalImpl;


public class ActionNodeImpl extends ModelInstance<ActionNode,Sql> implements ActionNode {

    public static final String KEY_LETTERS = "A_ACT";
    public static final ActionNode EMPTY_ACTIONNODE = new EmptyActionNode();

    private Sql context;

    // constructors
    private ActionNodeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        R1105_is_a_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R1107_is_a_AcceptEvent_inst = AcceptEventImpl.EMPTY_ACCEPTEVENT;
        R1107_is_a_ActivityDiagramAction_inst = ActivityDiagramActionImpl.EMPTY_ACTIVITYDIAGRAMACTION;
        R1107_is_a_SendSignal_inst = SendSignalImpl.EMPTY_SENDSIGNAL;
    }

    private ActionNodeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        R1105_is_a_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R1107_is_a_AcceptEvent_inst = AcceptEventImpl.EMPTY_ACCEPTEVENT;
        R1107_is_a_ActivityDiagramAction_inst = ActivityDiagramActionImpl.EMPTY_ACTIVITYDIAGRAMACTION;
        R1107_is_a_SendSignal_inst = SendSignalImpl.EMPTY_SENDSIGNAL;
    }

    public static ActionNode create( Sql context ) throws XtumlException {
        ActionNode newActionNode = new ActionNodeImpl( context );
        if ( context.addInstance( newActionNode ) ) {
            newActionNode.getRunContext().addChange(new InstanceCreatedDelta(newActionNode, KEY_LETTERS));
            return newActionNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActionNode create( Sql context, UniqueId instanceId, UniqueId ref_Id ) throws XtumlException {
        ActionNode newActionNode = new ActionNodeImpl( context, instanceId, ref_Id );
        if ( context.addInstance( newActionNode ) ) {
            return newActionNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R1107_is_a_SendSignal().isEmpty() ) R1107_is_a_SendSignal().setId( ref_Id );
            if ( !R1107_is_a_ActivityDiagramAction().isEmpty() ) R1107_is_a_ActivityDiagramAction().setId( ref_Id );
            if ( !R1107_is_a_AcceptEvent().isEmpty() ) R1107_is_a_AcceptEvent().setId( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActivityNode R1105_is_a_ActivityNode_inst;
    @Override
    public void setR1105_is_a_ActivityNode( ActivityNode inst ) {
        R1105_is_a_ActivityNode_inst = inst;
    }
    @Override
    public ActivityNode R1105_is_a_ActivityNode() throws XtumlException {
        return R1105_is_a_ActivityNode_inst;
    }
    private AcceptEvent R1107_is_a_AcceptEvent_inst;
    @Override
    public void setR1107_is_a_AcceptEvent( AcceptEvent inst ) {
        R1107_is_a_AcceptEvent_inst = inst;
    }
    @Override
    public AcceptEvent R1107_is_a_AcceptEvent() throws XtumlException {
        return R1107_is_a_AcceptEvent_inst;
    }
    private ActivityDiagramAction R1107_is_a_ActivityDiagramAction_inst;
    @Override
    public void setR1107_is_a_ActivityDiagramAction( ActivityDiagramAction inst ) {
        R1107_is_a_ActivityDiagramAction_inst = inst;
    }
    @Override
    public ActivityDiagramAction R1107_is_a_ActivityDiagramAction() throws XtumlException {
        return R1107_is_a_ActivityDiagramAction_inst;
    }
    private SendSignal R1107_is_a_SendSignal_inst;
    @Override
    public void setR1107_is_a_SendSignal( SendSignal inst ) {
        R1107_is_a_SendSignal_inst = inst;
    }
    @Override
    public SendSignal R1107_is_a_SendSignal() throws XtumlException {
        return R1107_is_a_SendSignal_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActionNode self() {
        return this;
    }

    @Override
    public ActionNode oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACTIONNODE;
    }

}

class EmptyActionNode extends ModelInstance<ActionNode,Sql> implements ActionNode {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActivityNode R1105_is_a_ActivityNode() {
        return ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }
    @Override
    public AcceptEvent R1107_is_a_AcceptEvent() {
        return AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }
    @Override
    public ActivityDiagramAction R1107_is_a_ActivityDiagramAction() {
        return ActivityDiagramActionImpl.EMPTY_ACTIVITYDIAGRAMACTION;
    }
    @Override
    public SendSignal R1107_is_a_SendSignal() {
        return SendSignalImpl.EMPTY_SENDSIGNAL;
    }


    @Override
    public String getKeyLetters() {
        return ActionNodeImpl.KEY_LETTERS;
    }

    @Override
    public ActionNode self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActionNode oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ActionNodeImpl.EMPTY_ACTIONNODE;
    }

}
