package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.AcceptEvent;
import io.ciera.tool.sql.ooaofooa.activity.AcceptEventAction;
import io.ciera.tool.sql.ooaofooa.activity.AcceptTimeEventAction;
import io.ciera.tool.sql.ooaofooa.activity.ActionNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.AcceptEventActionImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.AcceptTimeEventActionImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActionNodeImpl;


public class AcceptEventImpl extends ModelInstance<AcceptEvent,Sql> implements AcceptEvent {

    public static final String KEY_LETTERS = "A_AE";
    public static final AcceptEvent EMPTY_ACCEPTEVENT = new EmptyAcceptEvent();

    private Sql context;

    // constructors
    private AcceptEventImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        R1107_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
        R1112_is_a_AcceptEventAction_inst = AcceptEventActionImpl.EMPTY_ACCEPTEVENTACTION;
        R1112_is_a_AcceptTimeEventAction_inst = AcceptTimeEventActionImpl.EMPTY_ACCEPTTIMEEVENTACTION;
    }

    private AcceptEventImpl( Sql context, UniqueId instanceId, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        R1107_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
        R1112_is_a_AcceptEventAction_inst = AcceptEventActionImpl.EMPTY_ACCEPTEVENTACTION;
        R1112_is_a_AcceptTimeEventAction_inst = AcceptTimeEventActionImpl.EMPTY_ACCEPTTIMEEVENTACTION;
    }

    public static AcceptEvent create( Sql context ) throws XtumlException {
        AcceptEvent newAcceptEvent = new AcceptEventImpl( context );
        if ( context.addInstance( newAcceptEvent ) ) {
            newAcceptEvent.getRunContext().addChange(new InstanceCreatedDelta(newAcceptEvent, KEY_LETTERS));
            return newAcceptEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AcceptEvent create( Sql context, UniqueId instanceId, UniqueId ref_Id ) throws XtumlException {
        AcceptEvent newAcceptEvent = new AcceptEventImpl( context, instanceId, ref_Id );
        if ( context.addInstance( newAcceptEvent ) ) {
            return newAcceptEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R1112_is_a_AcceptTimeEventAction().isEmpty() ) R1112_is_a_AcceptTimeEventAction().setId( ref_Id );
            if ( !R1112_is_a_AcceptEventAction().isEmpty() ) R1112_is_a_AcceptEventAction().setId( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActionNode R1107_is_a_ActionNode_inst;
    @Override
    public void setR1107_is_a_ActionNode( ActionNode inst ) {
        R1107_is_a_ActionNode_inst = inst;
    }
    @Override
    public ActionNode R1107_is_a_ActionNode() throws XtumlException {
        return R1107_is_a_ActionNode_inst;
    }
    private AcceptEventAction R1112_is_a_AcceptEventAction_inst;
    @Override
    public void setR1112_is_a_AcceptEventAction( AcceptEventAction inst ) {
        R1112_is_a_AcceptEventAction_inst = inst;
    }
    @Override
    public AcceptEventAction R1112_is_a_AcceptEventAction() throws XtumlException {
        return R1112_is_a_AcceptEventAction_inst;
    }
    private AcceptTimeEventAction R1112_is_a_AcceptTimeEventAction_inst;
    @Override
    public void setR1112_is_a_AcceptTimeEventAction( AcceptTimeEventAction inst ) {
        R1112_is_a_AcceptTimeEventAction_inst = inst;
    }
    @Override
    public AcceptTimeEventAction R1112_is_a_AcceptTimeEventAction() throws XtumlException {
        return R1112_is_a_AcceptTimeEventAction_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AcceptEvent self() {
        return this;
    }

    @Override
    public AcceptEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACCEPTEVENT;
    }

}

class EmptyAcceptEvent extends ModelInstance<AcceptEvent,Sql> implements AcceptEvent {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActionNode R1107_is_a_ActionNode() {
        return ActionNodeImpl.EMPTY_ACTIONNODE;
    }
    @Override
    public AcceptEventAction R1112_is_a_AcceptEventAction() {
        return AcceptEventActionImpl.EMPTY_ACCEPTEVENTACTION;
    }
    @Override
    public AcceptTimeEventAction R1112_is_a_AcceptTimeEventAction() {
        return AcceptTimeEventActionImpl.EMPTY_ACCEPTTIMEEVENTACTION;
    }


    @Override
    public String getKeyLetters() {
        return AcceptEventImpl.KEY_LETTERS;
    }

    @Override
    public AcceptEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AcceptEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }

}
