package io.ciera.tool.sql.ooaofmarking.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.ooaofmarking.FeatureSet;
import io.ciera.tool.sql.ooaofmarking.Mark;
import io.ciera.tool.sql.ooaofmarking.MarkSet;
import io.ciera.tool.sql.ooaofmarking.MarkableElementTypeSet;
import io.ciera.tool.sql.ooaofmarking.impl.FeatureSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkableElementTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class MarkSetImpl extends InstanceSet<MarkSet,Mark> implements MarkSet {

    public MarkSetImpl() {
    }

    public MarkSetImpl(Comparator<? super Mark> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setFeature_name( String ref_feature_name ) throws XtumlException {
        for ( Mark mark : this ) mark.setFeature_name( ref_feature_name );
    }
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( Mark mark : this ) mark.setValue( m_value );
    }
    @Override
    public void setMarkable_name( String ref_markable_name ) throws XtumlException {
        for ( Mark mark : this ) mark.setMarkable_name( ref_markable_name );
    }
    @Override
    public void setPath( String m_path ) throws XtumlException {
        for ( Mark mark : this ) mark.setPath( m_path );
    }


    // selections
    @Override
    public FeatureSet R2821_is_marked_by_Feature() throws XtumlException {
        FeatureSet featureset = new FeatureSetImpl();
        for ( Mark mark : this ) featureset.add( mark.R2821_is_marked_by_Feature() );
        return featureset;
    }
    @Override
    public MarkableElementTypeSet R2821_marks_MarkableElementType() throws XtumlException {
        MarkableElementTypeSet markableelementtypeset = new MarkableElementTypeSetImpl();
        for ( Mark mark : this ) markableelementtypeset.add( mark.R2821_marks_MarkableElementType() );
        return markableelementtypeset;
    }
    @Override
    public MarkSet R2823_precedes_Mark() throws XtumlException {
        MarkSet markset = new MarkSetImpl();
        for ( Mark mark : this ) markset.add( mark.R2823_precedes_Mark() );
        return markset;
    }
    @Override
    public MarkSet R2823_succeeds_Mark() throws XtumlException {
        MarkSet markset = new MarkSetImpl();
        for ( Mark mark : this ) markset.add( mark.R2823_succeeds_Mark() );
        return markset;
    }


    @Override
    public Mark nullElement() {
        return MarkImpl.EMPTY_MARK;
    }

    @Override
    public MarkSet emptySet() {
      return new MarkSetImpl();
    }

    @Override
    public MarkSet emptySet(Comparator<? super Mark> comp) {
      return new MarkSetImpl(comp);
    }

    @Override
    public List<Mark> elements() {
        return Arrays.asList(toArray(new Mark[0]));
    }

}
