package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeSerializer;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.ClassInstanceSerializer;
import io.ciera.tool.sql.loader.EventInstanceSerializer;
import io.ciera.tool.sql.loader.InstanceSerializer;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.TimerInstanceSerializer;
import io.ciera.tool.sql.loader.impl.AttributeSerializerSetImpl;
import io.ciera.tool.sql.loader.impl.ClassInstanceSerializerImpl;
import io.ciera.tool.sql.loader.impl.EventInstanceSerializerImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderImpl;
import io.ciera.tool.sql.loader.impl.TimerInstanceSerializerImpl;


public class InstanceSerializerImpl extends ModelInstance<InstanceSerializer,Sql> implements InstanceSerializer {

    public static final String KEY_LETTERS = "Z_InstanceSerializer";
    public static final InstanceSerializer EMPTY_INSTANCESERIALIZER = new EmptyInstanceSerializer();

    private Sql context;

    // constructors
    private InstanceSerializerImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        m_class_name = "";
        R3001_invoked_by_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3002_serializes_data_value_using_AttributeSerializer_set = new AttributeSerializerSetImpl();
        R3015_is_a_ClassInstanceSerializer_inst = ClassInstanceSerializerImpl.EMPTY_CLASSINSTANCESERIALIZER;
        R3015_is_a_EventInstanceSerializer_inst = EventInstanceSerializerImpl.EMPTY_EVENTINSTANCESERIALIZER;
        R3015_is_a_TimerInstanceSerializer_inst = TimerInstanceSerializerImpl.EMPTY_TIMERINSTANCESERIALIZER;
    }

    private InstanceSerializerImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String m_class_name ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.m_class_name = m_class_name;
        R3001_invoked_by_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3002_serializes_data_value_using_AttributeSerializer_set = new AttributeSerializerSetImpl();
        R3015_is_a_ClassInstanceSerializer_inst = ClassInstanceSerializerImpl.EMPTY_CLASSINSTANCESERIALIZER;
        R3015_is_a_EventInstanceSerializer_inst = EventInstanceSerializerImpl.EMPTY_EVENTINSTANCESERIALIZER;
        R3015_is_a_TimerInstanceSerializer_inst = TimerInstanceSerializerImpl.EMPTY_TIMERINSTANCESERIALIZER;
    }

    public static InstanceSerializer create( Sql context ) throws XtumlException {
        InstanceSerializer newInstanceSerializer = new InstanceSerializerImpl( context );
        if ( context.addInstance( newInstanceSerializer ) ) {
            newInstanceSerializer.getRunContext().addChange(new InstanceCreatedDelta(newInstanceSerializer, KEY_LETTERS));
            return newInstanceSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceSerializer create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String m_class_name ) throws XtumlException {
        InstanceSerializer newInstanceSerializer = new InstanceSerializerImpl( context, instanceId, ref_loader_name, ref_loader_package, m_class_name );
        if ( context.addInstance( newInstanceSerializer ) ) {
            return newInstanceSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
            if ( !R3015_is_a_TimerInstanceSerializer().isEmpty() ) R3015_is_a_TimerInstanceSerializer().setLoader_name( ref_loader_name );
            if ( !R3002_serializes_data_value_using_AttributeSerializer().isEmpty() ) R3002_serializes_data_value_using_AttributeSerializer().setLoader_name( ref_loader_name );
            if ( !R3015_is_a_ClassInstanceSerializer().isEmpty() ) R3015_is_a_ClassInstanceSerializer().setLoader_name( ref_loader_name );
            if ( !R3015_is_a_EventInstanceSerializer().isEmpty() ) R3015_is_a_EventInstanceSerializer().setLoader_name( ref_loader_name );
        }
    }
    private String ref_loader_package;
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
            if ( !R3015_is_a_EventInstanceSerializer().isEmpty() ) R3015_is_a_EventInstanceSerializer().setLoader_package( ref_loader_package );
            if ( !R3015_is_a_ClassInstanceSerializer().isEmpty() ) R3015_is_a_ClassInstanceSerializer().setLoader_package( ref_loader_package );
            if ( !R3015_is_a_TimerInstanceSerializer().isEmpty() ) R3015_is_a_TimerInstanceSerializer().setLoader_package( ref_loader_package );
            if ( !R3002_serializes_data_value_using_AttributeSerializer().isEmpty() ) R3002_serializes_data_value_using_AttributeSerializer().setLoader_package( ref_loader_package );
        }
    }
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    private String m_class_name;
    @Override
    public void setClass_name(String m_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_class_name, this.m_class_name)) {
            final String oldValue = this.m_class_name;
            this.m_class_name = m_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_class_name", oldValue, this.m_class_name));
            if ( !R3015_is_a_EventInstanceSerializer().isEmpty() ) R3015_is_a_EventInstanceSerializer().setClass_name( m_class_name );
            if ( !R3015_is_a_ClassInstanceSerializer().isEmpty() ) R3015_is_a_ClassInstanceSerializer().setClass_name( m_class_name );
            if ( !R3015_is_a_TimerInstanceSerializer().isEmpty() ) R3015_is_a_TimerInstanceSerializer().setClass_name( m_class_name );
            if ( !R3002_serializes_data_value_using_AttributeSerializer().isEmpty() ) R3002_serializes_data_value_using_AttributeSerializer().setClass_name( m_class_name );
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return m_class_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        ClassInstanceSerializer classinstanceserializer = self().R3015_is_a_ClassInstanceSerializer();
        if ( !classinstanceserializer.isEmpty() ) {
            classinstanceserializer.render();
        }
        else {
            EventInstanceSerializer eventinstanceserializer = self().R3015_is_a_EventInstanceSerializer();
            if ( !eventinstanceserializer.isEmpty() ) {
                eventinstanceserializer.render();
            }
            else {
                TimerInstanceSerializer timerinstanceserializer = self().R3015_is_a_TimerInstanceSerializer();
                if ( !timerinstanceserializer.isEmpty() ) {
                    timerinstanceserializer.render();
                }
                else {
                    throw new XtumlException("No subtype selected");
                }
            }
        }
    }

    @Override
    public void render_def() throws XtumlException {
        ClassInstanceSerializer classinstanceserializer = self().R3015_is_a_ClassInstanceSerializer();
        if ( !classinstanceserializer.isEmpty() ) {
            classinstanceserializer.render_def();
        }
        else {
            EventInstanceSerializer eventinstanceserializer = self().R3015_is_a_EventInstanceSerializer();
            if ( !eventinstanceserializer.isEmpty() ) {
                eventinstanceserializer.render_def();
            }
            else {
                TimerInstanceSerializer timerinstanceserializer = self().R3015_is_a_TimerInstanceSerializer();
                if ( !timerinstanceserializer.isEmpty() ) {
                    timerinstanceserializer.render_def();
                }
                else {
                    throw new XtumlException("No subtype selected");
                }
            }
        }
    }

    @Override
    public void render_init() throws XtumlException {
        ClassInstanceSerializer classinstanceserializer = self().R3015_is_a_ClassInstanceSerializer();
        if ( !classinstanceserializer.isEmpty() ) {
            classinstanceserializer.render_init();
        }
        else {
            EventInstanceSerializer eventinstanceserializer = self().R3015_is_a_EventInstanceSerializer();
            if ( !eventinstanceserializer.isEmpty() ) {
                eventinstanceserializer.render_init();
            }
            else {
                TimerInstanceSerializer timerinstanceserializer = self().R3015_is_a_TimerInstanceSerializer();
                if ( !timerinstanceserializer.isEmpty() ) {
                    timerinstanceserializer.render_init();
                }
                else {
                    throw new XtumlException("No subtype selected");
                }
            }
        }
    }



    // static operations


    // events


    // selections
    private PopulationLoader R3001_invoked_by_PopulationLoader_inst;
    @Override
    public void setR3001_invoked_by_PopulationLoader( PopulationLoader inst ) {
        R3001_invoked_by_PopulationLoader_inst = inst;
    }
    @Override
    public PopulationLoader R3001_invoked_by_PopulationLoader() throws XtumlException {
        return R3001_invoked_by_PopulationLoader_inst;
    }
    private AttributeSerializerSet R3002_serializes_data_value_using_AttributeSerializer_set;
    @Override
    public void addR3002_serializes_data_value_using_AttributeSerializer( AttributeSerializer inst ) {
        R3002_serializes_data_value_using_AttributeSerializer_set.add(inst);
    }
    @Override
    public void removeR3002_serializes_data_value_using_AttributeSerializer( AttributeSerializer inst ) {
        R3002_serializes_data_value_using_AttributeSerializer_set.remove(inst);
    }
    @Override
    public AttributeSerializerSet R3002_serializes_data_value_using_AttributeSerializer() throws XtumlException {
        return R3002_serializes_data_value_using_AttributeSerializer_set;
    }
    private ClassInstanceSerializer R3015_is_a_ClassInstanceSerializer_inst;
    @Override
    public void setR3015_is_a_ClassInstanceSerializer( ClassInstanceSerializer inst ) {
        R3015_is_a_ClassInstanceSerializer_inst = inst;
    }
    @Override
    public ClassInstanceSerializer R3015_is_a_ClassInstanceSerializer() throws XtumlException {
        return R3015_is_a_ClassInstanceSerializer_inst;
    }
    private EventInstanceSerializer R3015_is_a_EventInstanceSerializer_inst;
    @Override
    public void setR3015_is_a_EventInstanceSerializer( EventInstanceSerializer inst ) {
        R3015_is_a_EventInstanceSerializer_inst = inst;
    }
    @Override
    public EventInstanceSerializer R3015_is_a_EventInstanceSerializer() throws XtumlException {
        return R3015_is_a_EventInstanceSerializer_inst;
    }
    private TimerInstanceSerializer R3015_is_a_TimerInstanceSerializer_inst;
    @Override
    public void setR3015_is_a_TimerInstanceSerializer( TimerInstanceSerializer inst ) {
        R3015_is_a_TimerInstanceSerializer_inst = inst;
    }
    @Override
    public TimerInstanceSerializer R3015_is_a_TimerInstanceSerializer() throws XtumlException {
        return R3015_is_a_TimerInstanceSerializer_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceSerializer self() {
        return this;
    }

    @Override
    public InstanceSerializer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCESERIALIZER;
    }

}

class EmptyInstanceSerializer extends ModelInstance<InstanceSerializer,Sql> implements InstanceSerializer {

    // attributes
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String m_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_def() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_init() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public PopulationLoader R3001_invoked_by_PopulationLoader() {
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }
    @Override
    public AttributeSerializerSet R3002_serializes_data_value_using_AttributeSerializer() {
        return (new AttributeSerializerSetImpl());
    }
    @Override
    public ClassInstanceSerializer R3015_is_a_ClassInstanceSerializer() {
        return ClassInstanceSerializerImpl.EMPTY_CLASSINSTANCESERIALIZER;
    }
    @Override
    public EventInstanceSerializer R3015_is_a_EventInstanceSerializer() {
        return EventInstanceSerializerImpl.EMPTY_EVENTINSTANCESERIALIZER;
    }
    @Override
    public TimerInstanceSerializer R3015_is_a_TimerInstanceSerializer() {
        return TimerInstanceSerializerImpl.EMPTY_TIMERINSTANCESERIALIZER;
    }


    @Override
    public String getKeyLetters() {
        return InstanceSerializerImpl.KEY_LETTERS;
    }

    @Override
    public InstanceSerializer self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceSerializer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
    }

}
