package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.loader.AttributeLoader;
import io.ciera.tool.sql.loader.EventInstanceLoader;
import io.ciera.tool.sql.loader.InstanceLoader;
import io.ciera.tool.sql.loader.impl.InstanceLoaderImpl;


public class EventInstanceLoaderImpl extends ModelInstance<EventInstanceLoader,Sql> implements EventInstanceLoader {

    public static final String KEY_LETTERS = "EventInstanceLoader";
    public static final EventInstanceLoader EMPTY_EVENTINSTANCELOADER = new EmptyEventInstanceLoader();

    private Sql context;

    // constructors
    private EventInstanceLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_evt_class_name = "";
        ref_class_name = "";
        ref_class_package = "";
        ref_comp_name = "";
        ref_comp_package = "";
        R3016_is_a_InstanceLoader_inst = InstanceLoaderImpl.EMPTY_INSTANCELOADER;
        R3017_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
    }

    private EventInstanceLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_evt_class_name, String ref_class_name, String ref_class_package, String ref_comp_name, String ref_comp_package ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_evt_class_name = ref_evt_class_name;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        R3016_is_a_InstanceLoader_inst = InstanceLoaderImpl.EMPTY_INSTANCELOADER;
        R3017_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
    }

    public static EventInstanceLoader create( Sql context ) throws XtumlException {
        EventInstanceLoader newEventInstanceLoader = new EventInstanceLoaderImpl( context );
        if ( context.addInstance( newEventInstanceLoader ) ) {
            newEventInstanceLoader.getRunContext().addChange(new InstanceCreatedDelta(newEventInstanceLoader, KEY_LETTERS));
            return newEventInstanceLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventInstanceLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_evt_class_name, String ref_class_name, String ref_class_package, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        EventInstanceLoader newEventInstanceLoader = new EventInstanceLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_evt_class_name, ref_class_name, ref_class_package, ref_comp_name, ref_comp_package );
        if ( context.addInstance( newEventInstanceLoader ) ) {
            return newEventInstanceLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    private String ref_evt_class_name;
    @Override
    public String getEvt_class_name() throws XtumlException {
        checkLiving();
        return ref_evt_class_name;
    }
    @Override
    public void setEvt_class_name(String ref_evt_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_evt_class_name, this.ref_evt_class_name)) {
            final String oldValue = this.ref_evt_class_name;
            this.ref_evt_class_name = ref_evt_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_evt_class_name", oldValue, this.ref_evt_class_name));
        }
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private String ref_class_package;
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return ref_class_package;
    }
    @Override
    public void setClass_package(String ref_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_package, this.ref_class_package)) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
        }
    }
    private String ref_comp_name;
    @Override
    public void setComp_name(String ref_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_name, this.ref_comp_name)) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
        return ref_comp_name;
    }
    private String ref_comp_package;
    @Override
    public void setComp_package(String ref_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_package, this.ref_comp_package)) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
        return ref_comp_package;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getEvt_class_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        String event_handle = "";
        String population_id = "";
        String event_target = "";
        AttributeLoader attr_loader = self().R3016_is_a_InstanceLoader().R3006_loads_data_value_using_AttributeLoader().any();
        AttributeLoader prev_attr_loader = attr_loader.R3007_follows_AttributeLoader();
        while ( !prev_attr_loader.isEmpty() ) {
            attr_loader = prev_attr_loader;
            prev_attr_loader = attr_loader.R3007_follows_AttributeLoader();
        }
        String sep = "";
        while ( !attr_loader.isEmpty() ) {
            context().T().append( sep );
            attr_loader.render();
            if ( attr_loader.getIndex() == 0 ) {
                event_handle = context().T().body();
                context().T().clear();
            }
            else if ( attr_loader.getIndex() == 1 ) {
                population_id = context().T().body();
                context().T().clear();
            }
            else if ( attr_loader.getIndex() == 2 ) {
                event_target = context().T().body();
                context().T().clear();
            }
            else {
                sep = ", ";
            }
            attr_loader = attr_loader.R3007_precedes_AttributeLoader();
        }
        String attribute_loaders = context().T().body();
        String class_name = ( context().STRING().substr( self().getEvt_class_name(), 0, context().STRING().indexof( self().getEvt_class_name(), "_" ) ) + "Impl." ) + context().STRING().substr( self().getEvt_class_name(), context().STRING().indexof( self().getEvt_class_name(), "_" ) + 1, -1 );
        context().T().pop_buffer();
        context().T().include( "loader/t.eventinstanceloader.java", attribute_loaders, class_name, event_handle, event_target, population_id, self() );
    }



    // static operations


    // events


    // selections
    private InstanceLoader R3016_is_a_InstanceLoader_inst;
    @Override
    public void setR3016_is_a_InstanceLoader( InstanceLoader inst ) {
        R3016_is_a_InstanceLoader_inst = inst;
    }
    @Override
    public InstanceLoader R3016_is_a_InstanceLoader() throws XtumlException {
        return R3016_is_a_InstanceLoader_inst;
    }
    private ModelInst R3017_ModelInst_inst;
    @Override
    public void setR3017_ModelInst( ModelInst inst ) {
        R3017_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R3017_ModelInst() throws XtumlException {
        return R3017_ModelInst_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventInstanceLoader self() {
        return this;
    }

    @Override
    public EventInstanceLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTINSTANCELOADER;
    }

}

class EmptyEventInstanceLoader extends ModelInstance<EventInstanceLoader,Sql> implements EventInstanceLoader {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getEvt_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvt_class_name( String ref_evt_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InstanceLoader R3016_is_a_InstanceLoader() {
        return InstanceLoaderImpl.EMPTY_INSTANCELOADER;
    }
    @Override
    public ModelInst R3017_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }


    @Override
    public String getKeyLetters() {
        return EventInstanceLoaderImpl.KEY_LETTERS;
    }

    @Override
    public EventInstanceLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventInstanceLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventInstanceLoaderImpl.EMPTY_EVENTINSTANCELOADER;
    }

}
