package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeComparison;
import io.ciera.tool.sql.loader.BatchRelator;
import io.ciera.tool.sql.loader.impl.AttributeComparisonImpl;
import io.ciera.tool.sql.loader.impl.BatchRelatorImpl;


public class AttributeComparisonImpl extends ModelInstance<AttributeComparison,Sql> implements AttributeComparison {

    public static final String KEY_LETTERS = "Z_AttributeComparison";
    public static final AttributeComparison EMPTY_ATTRIBUTECOMPARISON = new EmptyAttributeComparison();

    private Sql context;

    // constructors
    private AttributeComparisonImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_rel_name = "";
        m_part_attr_name = "";
        m_form_accessor = "";
        m_part_accessor = "";
        m_primitive = false;
        m_is_string = false;
        ref_prev_part_attr_name = "";
        R3012_evaluated_by_BatchRelator_inst = BatchRelatorImpl.EMPTY_BATCHRELATOR;
        R3018_precedes_AttributeComparison_inst = AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
        R3018_succeeds_AttributeComparison_inst = AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
    }

    private AttributeComparisonImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_rel_name, String m_part_attr_name, String m_form_accessor, String m_part_accessor, boolean m_primitive, boolean m_is_string, String ref_prev_part_attr_name ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_rel_name = ref_rel_name;
        this.m_part_attr_name = m_part_attr_name;
        this.m_form_accessor = m_form_accessor;
        this.m_part_accessor = m_part_accessor;
        this.m_primitive = m_primitive;
        this.m_is_string = m_is_string;
        this.ref_prev_part_attr_name = ref_prev_part_attr_name;
        R3012_evaluated_by_BatchRelator_inst = BatchRelatorImpl.EMPTY_BATCHRELATOR;
        R3018_precedes_AttributeComparison_inst = AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
        R3018_succeeds_AttributeComparison_inst = AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
    }

    public static AttributeComparison create( Sql context ) throws XtumlException {
        AttributeComparison newAttributeComparison = new AttributeComparisonImpl( context );
        if ( context.addInstance( newAttributeComparison ) ) {
            newAttributeComparison.getRunContext().addChange(new InstanceCreatedDelta(newAttributeComparison, KEY_LETTERS));
            return newAttributeComparison;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeComparison create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_rel_name, String m_part_attr_name, String m_form_accessor, String m_part_accessor, boolean m_primitive, boolean m_is_string, String ref_prev_part_attr_name ) throws XtumlException {
        AttributeComparison newAttributeComparison = new AttributeComparisonImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_rel_name, m_part_attr_name, m_form_accessor, m_part_accessor, m_primitive, m_is_string, ref_prev_part_attr_name );
        if ( context.addInstance( newAttributeComparison ) ) {
            return newAttributeComparison;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
            if ( !R3018_precedes_AttributeComparison().isEmpty() ) R3018_precedes_AttributeComparison().setLoader_name( ref_loader_name );
        }
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
            if ( !R3018_precedes_AttributeComparison().isEmpty() ) R3018_precedes_AttributeComparison().setLoader_package( ref_loader_package );
        }
    }
    private String ref_rel_name;
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return ref_rel_name;
    }
    @Override
    public void setRel_name(String ref_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_rel_name, this.ref_rel_name)) {
            final String oldValue = this.ref_rel_name;
            this.ref_rel_name = ref_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_name", oldValue, this.ref_rel_name));
            if ( !R3018_precedes_AttributeComparison().isEmpty() ) R3018_precedes_AttributeComparison().setRel_name( ref_rel_name );
        }
    }
    private String m_part_attr_name;
    @Override
    public String getPart_attr_name() throws XtumlException {
        checkLiving();
        return m_part_attr_name;
    }
    @Override
    public void setPart_attr_name(String m_part_attr_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_part_attr_name, this.m_part_attr_name)) {
            final String oldValue = this.m_part_attr_name;
            this.m_part_attr_name = m_part_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_part_attr_name", oldValue, this.m_part_attr_name));
            if ( !R3018_precedes_AttributeComparison().isEmpty() ) R3018_precedes_AttributeComparison().setPrev_part_attr_name( m_part_attr_name );
        }
    }
    private String m_form_accessor;
    @Override
    public void setForm_accessor(String m_form_accessor) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_form_accessor, this.m_form_accessor)) {
            final String oldValue = this.m_form_accessor;
            this.m_form_accessor = m_form_accessor;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_form_accessor", oldValue, this.m_form_accessor));
        }
    }
    @Override
    public String getForm_accessor() throws XtumlException {
        checkLiving();
        return m_form_accessor;
    }
    private String m_part_accessor;
    @Override
    public void setPart_accessor(String m_part_accessor) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_part_accessor, this.m_part_accessor)) {
            final String oldValue = this.m_part_accessor;
            this.m_part_accessor = m_part_accessor;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_part_accessor", oldValue, this.m_part_accessor));
        }
    }
    @Override
    public String getPart_accessor() throws XtumlException {
        checkLiving();
        return m_part_accessor;
    }
    private boolean m_primitive;
    @Override
    public boolean getPrimitive() throws XtumlException {
        checkLiving();
        return m_primitive;
    }
    @Override
    public void setPrimitive(boolean m_primitive) throws XtumlException {
        checkLiving();
        if (m_primitive != this.m_primitive) {
            final boolean oldValue = this.m_primitive;
            this.m_primitive = m_primitive;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_primitive", oldValue, this.m_primitive));
        }
    }
    private boolean m_is_string;
    @Override
    public void setIs_string(boolean m_is_string) throws XtumlException {
        checkLiving();
        if (m_is_string != this.m_is_string) {
            final boolean oldValue = this.m_is_string;
            this.m_is_string = m_is_string;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_string", oldValue, this.m_is_string));
        }
    }
    @Override
    public boolean getIs_string() throws XtumlException {
        checkLiving();
        return m_is_string;
    }
    private String ref_prev_part_attr_name;
    @Override
    public String getPrev_part_attr_name() throws XtumlException {
        checkLiving();
        return ref_prev_part_attr_name;
    }
    @Override
    public void setPrev_part_attr_name(String ref_prev_part_attr_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_prev_part_attr_name, this.ref_prev_part_attr_name)) {
            final String oldValue = this.ref_prev_part_attr_name;
            this.ref_prev_part_attr_name = ref_prev_part_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_prev_part_attr_name", oldValue, this.ref_prev_part_attr_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getRel_name(), getPart_attr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        BatchRelator batch_relator = self().R3012_evaluated_by_BatchRelator();
        if ( 0 == batch_relator.getId_num() ) {
            context().T().include( "loader/t.attributecomparison.java", self() );
        }
        else {
            context().T().append( "form." + self().getForm_accessor() );
        }
    }



    // static operations


    // events


    // selections
    private BatchRelator R3012_evaluated_by_BatchRelator_inst;
    @Override
    public void setR3012_evaluated_by_BatchRelator( BatchRelator inst ) {
        R3012_evaluated_by_BatchRelator_inst = inst;
    }
    @Override
    public BatchRelator R3012_evaluated_by_BatchRelator() throws XtumlException {
        return R3012_evaluated_by_BatchRelator_inst;
    }
    private AttributeComparison R3018_precedes_AttributeComparison_inst;
    @Override
    public void setR3018_precedes_AttributeComparison( AttributeComparison inst ) {
        R3018_precedes_AttributeComparison_inst = inst;
    }
    @Override
    public AttributeComparison R3018_precedes_AttributeComparison() throws XtumlException {
        return R3018_precedes_AttributeComparison_inst;
    }
    private AttributeComparison R3018_succeeds_AttributeComparison_inst;
    @Override
    public void setR3018_succeeds_AttributeComparison( AttributeComparison inst ) {
        R3018_succeeds_AttributeComparison_inst = inst;
    }
    @Override
    public AttributeComparison R3018_succeeds_AttributeComparison() throws XtumlException {
        return R3018_succeeds_AttributeComparison_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeComparison self() {
        return this;
    }

    @Override
    public AttributeComparison oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTECOMPARISON;
    }

}

class EmptyAttributeComparison extends ModelInstance<AttributeComparison,Sql> implements AttributeComparison {

    // attributes
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_attr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_attr_name( String m_part_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setForm_accessor( String m_form_accessor ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getForm_accessor() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_accessor( String m_part_accessor ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_accessor() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getPrimitive() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrimitive( boolean m_primitive ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIs_string( boolean m_is_string ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_string() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPrev_part_attr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrev_part_attr_name( String ref_prev_part_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public BatchRelator R3012_evaluated_by_BatchRelator() {
        return BatchRelatorImpl.EMPTY_BATCHRELATOR;
    }
    @Override
    public AttributeComparison R3018_precedes_AttributeComparison() {
        return AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
    }
    @Override
    public AttributeComparison R3018_succeeds_AttributeComparison() {
        return AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
    }


    @Override
    public String getKeyLetters() {
        return AttributeComparisonImpl.KEY_LETTERS;
    }

    @Override
    public AttributeComparison self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeComparison oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
    }

}
