package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.InstSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.FormalParameterSet;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.type.ArrayTypeReference;
import io.ciera.tool.sql.architecture.type.BasicTypeReference;
import io.ciera.tool.sql.architecture.type.BuiltInType;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.UnresolvedType;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.architecture.type.UserDefinedTypeSet;
import io.ciera.tool.sql.architecture.type.impl.BuiltInTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.impl.UnresolvedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeSetImpl;
import io.ciera.tool.sql.loader.GeneralLoader;
import io.ciera.tool.sql.loader.GeneralLoaderSet;
import io.ciera.tool.sql.loader.GeneralSerializer;
import io.ciera.tool.sql.loader.GeneralSerializerSet;
import io.ciera.tool.sql.loader.impl.GeneralLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.GeneralSerializerSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;

import java.util.Iterator;

import types.ImportType;


public class TypeImpl extends ModelInstance<Type,Sql> implements Type {

    public static final String KEY_LETTERS = "Type";
    public static final Type EMPTY_TYPE = new EmptyType();

    private Sql context;

    // constructors
    private TypeImpl( Sql context ) {
        this.context = context;
        m_name = "";
        m_package = "";
        m_default_value = "";
        ref_DT_ID = UniqueId.random();
        R3013_GeneralLoader_set = new GeneralLoaderSetImpl();
        R3014_GeneralSerializer_set = new GeneralSerializerSetImpl();
        R3800_referred_to_by_TypeReference_set = new TypeReferenceSetImpl();
        R3802_used_as_base_for_UserDefinedType_set = new UserDefinedTypeSetImpl();
        R407_is_a_BuiltInType_inst = BuiltInTypeImpl.EMPTY_BUILTINTYPE;
        R407_is_a_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R407_is_a_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R407_is_a_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R407_is_a_UnresolvedType_inst = UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
        R407_is_a_UserDefinedType_inst = UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
        R423_is_basis_for_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    private TypeImpl( Sql context, UniqueId instanceId, String m_name, String m_package, String m_default_value, UniqueId ref_DT_ID ) {
        super(instanceId);
        this.context = context;
        this.m_name = m_name;
        this.m_package = m_package;
        this.m_default_value = m_default_value;
        this.ref_DT_ID = ref_DT_ID;
        R3013_GeneralLoader_set = new GeneralLoaderSetImpl();
        R3014_GeneralSerializer_set = new GeneralSerializerSetImpl();
        R3800_referred_to_by_TypeReference_set = new TypeReferenceSetImpl();
        R3802_used_as_base_for_UserDefinedType_set = new UserDefinedTypeSetImpl();
        R407_is_a_BuiltInType_inst = BuiltInTypeImpl.EMPTY_BUILTINTYPE;
        R407_is_a_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R407_is_a_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R407_is_a_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R407_is_a_UnresolvedType_inst = UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
        R407_is_a_UserDefinedType_inst = UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
        R423_is_basis_for_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    public static Type create( Sql context ) throws XtumlException {
        Type newType = new TypeImpl( context );
        if ( context.addInstance( newType ) ) {
            newType.getRunContext().addChange(new InstanceCreatedDelta(newType, KEY_LETTERS));
            return newType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Type create( Sql context, UniqueId instanceId, String m_name, String m_package, String m_default_value, UniqueId ref_DT_ID ) throws XtumlException {
        Type newType = new TypeImpl( context, instanceId, m_name, m_package, m_default_value, ref_DT_ID );
        if ( context.addInstance( newType ) ) {
            return newType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R3802_used_as_base_for_UserDefinedType().isEmpty() ) R3802_used_as_base_for_UserDefinedType().setBase_type_name( m_name );
            if ( !R3014_GeneralSerializer().isEmpty() ) R3014_GeneralSerializer().setType_name( m_name );
            if ( !R407_is_a_UserDefinedType().isEmpty() ) R407_is_a_UserDefinedType().setName( m_name );
            if ( !R3800_referred_to_by_TypeReference().isEmpty() ) R3800_referred_to_by_TypeReference().setType_name( m_name );
            if ( !R3013_GeneralLoader().isEmpty() ) R3013_GeneralLoader().setType_name( m_name );
            if ( !R407_is_a_InstSet().isEmpty() ) R407_is_a_InstSet().setName( m_name );
            if ( !R407_is_a_UnresolvedType().isEmpty() ) R407_is_a_UnresolvedType().setName( m_name );
            if ( !R407_is_a_EnumeratedType().isEmpty() ) R407_is_a_EnumeratedType().setName( m_name );
            if ( !R407_is_a_ModelInst().isEmpty() ) R407_is_a_ModelInst().setName( m_name );
            if ( !R407_is_a_BuiltInType().isEmpty() ) R407_is_a_BuiltInType().setName( m_name );
        }
    }
    private String m_package;
    @Override
    public void setPackage(String m_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_package, this.m_package)) {
            final String oldValue = this.m_package;
            this.m_package = m_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_package", oldValue, this.m_package));
            if ( !R3800_referred_to_by_TypeReference().isEmpty() ) R3800_referred_to_by_TypeReference().setType_package( m_package );
            if ( !R407_is_a_InstSet().isEmpty() ) R407_is_a_InstSet().setPackage( m_package );
            if ( !R3013_GeneralLoader().isEmpty() ) R3013_GeneralLoader().setType_package( m_package );
            if ( !R407_is_a_ModelInst().isEmpty() ) R407_is_a_ModelInst().setPackage( m_package );
            if ( !R407_is_a_BuiltInType().isEmpty() ) R407_is_a_BuiltInType().setPackage( m_package );
            if ( !R3802_used_as_base_for_UserDefinedType().isEmpty() ) R3802_used_as_base_for_UserDefinedType().setBase_type_package( m_package );
            if ( !R407_is_a_UserDefinedType().isEmpty() ) R407_is_a_UserDefinedType().setPackage( m_package );
            if ( !R3014_GeneralSerializer().isEmpty() ) R3014_GeneralSerializer().setType_package( m_package );
            if ( !R407_is_a_UnresolvedType().isEmpty() ) R407_is_a_UnresolvedType().setPackage( m_package );
            if ( !R407_is_a_EnumeratedType().isEmpty() ) R407_is_a_EnumeratedType().setPackage( m_package );
        }
    }
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return m_package;
    }
    private String m_default_value;
    @Override
    public void setDefault_value(String m_default_value) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_default_value, this.m_default_value)) {
            final String oldValue = this.m_default_value;
            this.m_default_value = m_default_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_default_value", oldValue, this.m_default_value));
        }
    }
    @Override
    public String getDefault_value() throws XtumlException {
        checkLiving();
        return m_default_value;
    }
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void addToImports( final File p_file,  final ImportType p_type ) throws XtumlException {
        if ( StringUtil.inequality("", self().getPackage()) ) {
            context().addStringToImports( p_file, ( self().getPackage() + "." ) + self().getName(), p_type );
        }
    }

    @Override
    public void dispose() throws XtumlException {
        UnresolvedType unresolved_type = self().R407_is_a_UnresolvedType();
        if ( !unresolved_type.isEmpty() ) {
            unresolved_type.dispose();
        }
        ModelInst obj = self().R407_is_a_ModelInst();
        if ( !obj.isEmpty() ) {
            context().unrelate_R407_ModelInst_is_a_Type( obj, self() );
        }
        InstSet objset = self().R407_is_a_InstSet();
        if ( !objset.isEmpty() ) {
            context().unrelate_R407_InstSet_is_a_Type( objset, self() );
        }
        EnumeratedType edt = self().R407_is_a_EnumeratedType();
        if ( !edt.isEmpty() ) {
            context().unrelate_R407_EnumeratedType_is_a_Type( edt, self() );
        }
        BuiltInType builtin = self().R407_is_a_BuiltInType();
        if ( !builtin.isEmpty() ) {
            context().unrelate_R407_BuiltInType_is_a_Type( builtin, self() );
        }
        TypeReferenceSet type_refs = self().R3800_referred_to_by_TypeReference();
        TypeReference type_ref;
        for ( Iterator<TypeReference> _type_ref_iter = type_refs.elements().iterator(); _type_ref_iter.hasNext(); ) {
            type_ref = _type_ref_iter.next();
            BasicTypeReference basic_ref = type_ref.R3801_is_a_BasicTypeReference();
            if ( !basic_ref.isEmpty() ) {
                context().unrelate_R3801_BasicTypeReference_is_a_TypeReference( basic_ref, type_ref );
                basic_ref.delete();
            }
            ArrayTypeReference array_ref = type_ref.R3801_is_a_ArrayTypeReference();
            if ( !array_ref.isEmpty() ) {
                context().unrelate_R3801_ArrayTypeReference_is_a_TypeReference( array_ref, type_ref );
                array_ref.delete();
            }
            context().unrelate_R3800_TypeReference_based_on_Type( type_ref, self() );
            type_ref.delete();
        }
        self().delete();
    }

    @Override
    public boolean primitive() throws XtumlException {
        boolean primitive = false;
        BuiltInType builtin = self().R407_is_a_BuiltInType();
        if ( !builtin.isEmpty() ) {
            primitive = builtin.getPrimitive();
        }
        return primitive;
    }

    @Override
    public void resolve( final DataType p_s_dt ) throws XtumlException {
        DataType s_dt = p_s_dt;
        UnresolvedType unresolved_type = s_dt.R423_is_transformed_from_Type().R407_is_a_UnresolvedType();
        if ( !unresolved_type.isEmpty() ) {
            Type old_type = unresolved_type.R407_is_a_Type();
            TypeReferenceSet old_type_refs = old_type.R3800_referred_to_by_TypeReference();
            TypeReference old_type_ref;
            for ( Iterator<TypeReference> _old_type_ref_iter = old_type_refs.elements().iterator(); _old_type_ref_iter.hasNext(); ) {
                old_type_ref = _old_type_ref_iter.next();
                TypeReference self_ref = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
                BasicTypeReference old_basic_ref = old_type_ref.R3801_is_a_BasicTypeReference();
                if ( !old_basic_ref.isEmpty() ) {
                    self_ref = new TypeReferenceImpl.CLASS(context()).getInstanceWithDimString( self(), "" );
                }
                else {
                    ArrayTypeReference old_array_ref = old_type_ref.R3801_is_a_ArrayTypeReference();
                    if ( !old_array_ref.isEmpty() ) {
                        self_ref = new TypeReferenceImpl.CLASS(context()).getInstanceWithDimString( self(), old_array_ref.getDims() );
                    }
                }
                AttributeSet attrs = old_type_ref.R424_defines_type_for_Attribute();
                Attribute attr;
                for ( Iterator<Attribute> _attr_iter = attrs.elements().iterator(); _attr_iter.hasNext(); ) {
                    attr = _attr_iter.next();
                    context().unrelate_R424_Attribute_is_typed_by_TypeReference( attr, old_type_ref );
                    context().relate_R424_Attribute_is_typed_by_TypeReference( attr, self_ref );
                }
                InvocableObjectSet invocables = old_type_ref.R428_defines_return_type_for_InvocableObject();
                InvocableObject invocable;
                for ( Iterator<InvocableObject> _invocable_iter = invocables.elements().iterator(); _invocable_iter.hasNext(); ) {
                    invocable = _invocable_iter.next();
                    context().unrelate_R428_InvocableObject_return_value_is_typed_by_TypeReference( invocable, old_type_ref );
                    context().relate_R428_InvocableObject_return_value_is_typed_by_TypeReference( invocable, self_ref );
                }
                FormalParameterSet parms = old_type_ref.R431_defines_type_for_FormalParameter();
                FormalParameter parm;
                for ( Iterator<FormalParameter> _parm_iter = parms.elements().iterator(); _parm_iter.hasNext(); ) {
                    parm = _parm_iter.next();
                    context().unrelate_R431_FormalParameter_is_typed_by_TypeReference( parm, old_type_ref );
                    context().relate_R431_FormalParameter_is_typed_by_TypeReference( parm, self_ref );
                }
                SelectorSet selectors = old_type_ref.R446_shapes_return_of_Selector();
                Selector selector;
                for ( Iterator<Selector> _selector_iter = selectors.elements().iterator(); _selector_iter.hasNext(); ) {
                    selector = _selector_iter.next();
                    context().unrelate_R446_Selector_selects_instances_of_TypeReference( selector, old_type_ref );
                    context().relate_R446_Selector_selects_instances_of_TypeReference( selector, self_ref );
                }
                ExpressionSet expressions = old_type_ref.R795_defines_type_of_Expression();
                Expression expression;
                for ( Iterator<Expression> _expression_iter = expressions.elements().iterator(); _expression_iter.hasNext(); ) {
                    expression = _expression_iter.next();
                    context().unrelate_R795_Expression_expresses_value_of_TypeReference( expression, old_type_ref );
                    context().relate_R795_Expression_expresses_value_of_TypeReference( expression, self_ref );
                }
            }
            context().unrelate_R423_Type_is_basis_for_DataType( old_type, s_dt );
            context().relate_R423_Type_is_basis_for_DataType( self(), s_dt );
            old_type.dispose();
        }
        else if ( !s_dt.isEmpty() ) {
            context().relate_R423_Type_is_basis_for_DataType( self(), s_dt );
        }
        else {
        }
    }



    // static operations


    // events


    // selections
    private GeneralLoaderSet R3013_GeneralLoader_set;
    @Override
    public void addR3013_GeneralLoader( GeneralLoader inst ) {
        R3013_GeneralLoader_set.add(inst);
    }
    @Override
    public void removeR3013_GeneralLoader( GeneralLoader inst ) {
        R3013_GeneralLoader_set.remove(inst);
    }
    @Override
    public GeneralLoaderSet R3013_GeneralLoader() throws XtumlException {
        return R3013_GeneralLoader_set;
    }
    private GeneralSerializerSet R3014_GeneralSerializer_set;
    @Override
    public void addR3014_GeneralSerializer( GeneralSerializer inst ) {
        R3014_GeneralSerializer_set.add(inst);
    }
    @Override
    public void removeR3014_GeneralSerializer( GeneralSerializer inst ) {
        R3014_GeneralSerializer_set.remove(inst);
    }
    @Override
    public GeneralSerializerSet R3014_GeneralSerializer() throws XtumlException {
        return R3014_GeneralSerializer_set;
    }
    private TypeReferenceSet R3800_referred_to_by_TypeReference_set;
    @Override
    public void addR3800_referred_to_by_TypeReference( TypeReference inst ) {
        R3800_referred_to_by_TypeReference_set.add(inst);
    }
    @Override
    public void removeR3800_referred_to_by_TypeReference( TypeReference inst ) {
        R3800_referred_to_by_TypeReference_set.remove(inst);
    }
    @Override
    public TypeReferenceSet R3800_referred_to_by_TypeReference() throws XtumlException {
        return R3800_referred_to_by_TypeReference_set;
    }
    private UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType_set;
    @Override
    public void addR3802_used_as_base_for_UserDefinedType( UserDefinedType inst ) {
        R3802_used_as_base_for_UserDefinedType_set.add(inst);
    }
    @Override
    public void removeR3802_used_as_base_for_UserDefinedType( UserDefinedType inst ) {
        R3802_used_as_base_for_UserDefinedType_set.remove(inst);
    }
    @Override
    public UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType() throws XtumlException {
        return R3802_used_as_base_for_UserDefinedType_set;
    }
    private BuiltInType R407_is_a_BuiltInType_inst;
    @Override
    public void setR407_is_a_BuiltInType( BuiltInType inst ) {
        R407_is_a_BuiltInType_inst = inst;
    }
    @Override
    public BuiltInType R407_is_a_BuiltInType() throws XtumlException {
        return R407_is_a_BuiltInType_inst;
    }
    private EnumeratedType R407_is_a_EnumeratedType_inst;
    @Override
    public void setR407_is_a_EnumeratedType( EnumeratedType inst ) {
        R407_is_a_EnumeratedType_inst = inst;
    }
    @Override
    public EnumeratedType R407_is_a_EnumeratedType() throws XtumlException {
        return R407_is_a_EnumeratedType_inst;
    }
    private InstSet R407_is_a_InstSet_inst;
    @Override
    public void setR407_is_a_InstSet( InstSet inst ) {
        R407_is_a_InstSet_inst = inst;
    }
    @Override
    public InstSet R407_is_a_InstSet() throws XtumlException {
        return R407_is_a_InstSet_inst;
    }
    private ModelInst R407_is_a_ModelInst_inst;
    @Override
    public void setR407_is_a_ModelInst( ModelInst inst ) {
        R407_is_a_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R407_is_a_ModelInst() throws XtumlException {
        return R407_is_a_ModelInst_inst;
    }
    private UnresolvedType R407_is_a_UnresolvedType_inst;
    @Override
    public void setR407_is_a_UnresolvedType( UnresolvedType inst ) {
        R407_is_a_UnresolvedType_inst = inst;
    }
    @Override
    public UnresolvedType R407_is_a_UnresolvedType() throws XtumlException {
        return R407_is_a_UnresolvedType_inst;
    }
    private UserDefinedType R407_is_a_UserDefinedType_inst;
    @Override
    public void setR407_is_a_UserDefinedType( UserDefinedType inst ) {
        R407_is_a_UserDefinedType_inst = inst;
    }
    @Override
    public UserDefinedType R407_is_a_UserDefinedType() throws XtumlException {
        return R407_is_a_UserDefinedType_inst;
    }
    private DataType R423_is_basis_for_DataType_inst;
    @Override
    public void setR423_is_basis_for_DataType( DataType inst ) {
        R423_is_basis_for_DataType_inst = inst;
    }
    @Override
    public DataType R423_is_basis_for_DataType() throws XtumlException {
        return R423_is_basis_for_DataType_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Type self() {
        return this;
    }

    @Override
    public Type oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TYPE;
    }

}

class EmptyType extends ModelInstance<Type,Sql> implements Type {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPackage( String m_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDefault_value( String m_default_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDefault_value() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void addToImports( final File p_file,  final ImportType p_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void dispose() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public boolean primitive() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void resolve( final DataType p_s_dt ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public GeneralLoaderSet R3013_GeneralLoader() {
        return (new GeneralLoaderSetImpl());
    }
    @Override
    public GeneralSerializerSet R3014_GeneralSerializer() {
        return (new GeneralSerializerSetImpl());
    }
    @Override
    public TypeReferenceSet R3800_referred_to_by_TypeReference() {
        return (new TypeReferenceSetImpl());
    }
    @Override
    public UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType() {
        return (new UserDefinedTypeSetImpl());
    }
    @Override
    public BuiltInType R407_is_a_BuiltInType() {
        return BuiltInTypeImpl.EMPTY_BUILTINTYPE;
    }
    @Override
    public EnumeratedType R407_is_a_EnumeratedType() {
        return EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
    }
    @Override
    public InstSet R407_is_a_InstSet() {
        return InstSetImpl.EMPTY_INSTSET;
    }
    @Override
    public ModelInst R407_is_a_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public UnresolvedType R407_is_a_UnresolvedType() {
        return UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
    }
    @Override
    public UserDefinedType R407_is_a_UserDefinedType() {
        return UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
    }
    @Override
    public DataType R423_is_basis_for_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }


    @Override
    public String getKeyLetters() {
        return TypeImpl.KEY_LETTERS;
    }

    @Override
    public Type self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Type oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TypeImpl.EMPTY_TYPE;
    }

}
