package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.Enumerator;
import io.ciera.tool.sql.architecture.type.EnumeratorSet;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.impl.EnumeratorSetImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;
import io.ciera.tool.sql.loader.EnumeratorLoader;
import io.ciera.tool.sql.loader.EnumeratorLoaderSet;
import io.ciera.tool.sql.loader.impl.EnumeratorLoaderSetImpl;

import java.util.Iterator;

import types.ImportType;


public class EnumeratedTypeImpl extends ModelInstance<EnumeratedType,Sql> implements EnumeratedType {

    public static final String KEY_LETTERS = "EnumeratedType";
    public static final EnumeratedType EMPTY_ENUMERATEDTYPE = new EmptyEnumeratedType();

    private Sql context;

    // constructors
    private EnumeratedTypeImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        R3010_EnumeratorLoader_set = new EnumeratorLoaderSetImpl();
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
        R415_declares_Enumerator_set = new EnumeratorSetImpl();
    }

    private EnumeratedTypeImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        R3010_EnumeratorLoader_set = new EnumeratorLoaderSetImpl();
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
        R415_declares_Enumerator_set = new EnumeratorSetImpl();
    }

    public static EnumeratedType create( Sql context ) throws XtumlException {
        EnumeratedType newEnumeratedType = new EnumeratedTypeImpl( context );
        if ( context.addInstance( newEnumeratedType ) ) {
            newEnumeratedType.getRunContext().addChange(new InstanceCreatedDelta(newEnumeratedType, KEY_LETTERS));
            return newEnumeratedType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EnumeratedType create( Sql context, UniqueId instanceId, String ref_name, String ref_package ) throws XtumlException {
        EnumeratedType newEnumeratedType = new EnumeratedTypeImpl( context, instanceId, ref_name, ref_package );
        if ( context.addInstance( newEnumeratedType ) ) {
            return newEnumeratedType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R415_declares_Enumerator().isEmpty() ) R415_declares_Enumerator().setType_name( ref_name );
            if ( !R3010_EnumeratorLoader().isEmpty() ) R3010_EnumeratorLoader().setType_name( ref_name );
        }
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R3010_EnumeratorLoader().isEmpty() ) R3010_EnumeratorLoader().setType_package( ref_package );
            if ( !R415_declares_Enumerator().isEmpty() ) R415_declares_Enumerator().setType_package( ref_package );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        EnumeratorSet enums = self().R415_declares_Enumerator();
        Enumerator enumerator;
        for ( Iterator<Enumerator> _enumerator_iter = enums.elements().iterator(); _enumerator_iter.hasNext(); ) {
            enumerator = _enumerator_iter.next();
            context().T().append( ",\n" );
            enumerator.render();
        }
        context().T().append( ";" );
        String enumerators = context().T().body();
        context().T().clear();
        for ( Iterator<Enumerator> _enumerator_iter = enums.elements().iterator(); _enumerator_iter.hasNext(); ) {
            enumerator = _enumerator_iter.next();
            enumerator.render_accessor();
        }
        String enumerator_accessors = context().T().body();
        context().T().clear();
        context().T().include( "type/t.enumeratedtype.java", enumerator_accessors, enumerators, imports, self() );
        file = self().R401_is_a_File();
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }



    // static operations


    // events


    // selections
    private EnumeratorLoaderSet R3010_EnumeratorLoader_set;
    @Override
    public void addR3010_EnumeratorLoader( EnumeratorLoader inst ) {
        R3010_EnumeratorLoader_set.add(inst);
    }
    @Override
    public void removeR3010_EnumeratorLoader( EnumeratorLoader inst ) {
        R3010_EnumeratorLoader_set.remove(inst);
    }
    @Override
    public EnumeratorLoaderSet R3010_EnumeratorLoader() throws XtumlException {
        return R3010_EnumeratorLoader_set;
    }
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private Type R407_is_a_Type_inst;
    @Override
    public void setR407_is_a_Type( Type inst ) {
        R407_is_a_Type_inst = inst;
    }
    @Override
    public Type R407_is_a_Type() throws XtumlException {
        return R407_is_a_Type_inst;
    }
    private EnumeratorSet R415_declares_Enumerator_set;
    @Override
    public void addR415_declares_Enumerator( Enumerator inst ) {
        R415_declares_Enumerator_set.add(inst);
    }
    @Override
    public void removeR415_declares_Enumerator( Enumerator inst ) {
        R415_declares_Enumerator_set.remove(inst);
    }
    @Override
    public EnumeratorSet R415_declares_Enumerator() throws XtumlException {
        return R415_declares_Enumerator_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EnumeratedType self() {
        return this;
    }

    @Override
    public EnumeratedType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ENUMERATEDTYPE;
    }

}

class EmptyEnumeratedType extends ModelInstance<EnumeratedType,Sql> implements EnumeratedType {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public EnumeratorLoaderSet R3010_EnumeratorLoader() {
        return (new EnumeratorLoaderSetImpl());
    }
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public Type R407_is_a_Type() {
        return TypeImpl.EMPTY_TYPE;
    }
    @Override
    public EnumeratorSet R415_declares_Enumerator() {
        return (new EnumeratorSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return EnumeratedTypeImpl.KEY_LETTERS;
    }

    @Override
    public EnumeratedType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EnumeratedType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
    }

}
