package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.invocable.impl.CodeBlockImpl;
import io.ciera.tool.sql.architecture.statement.IfSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;


public class IfSmtImpl extends ModelInstance<IfSmt,Sql> implements IfSmt {

    public static final String KEY_LETTERS = "IfSmt";
    public static final IfSmt EMPTY_IFSMT = new EmptyIfSmt();

    private Sql context;

    // constructors
    private IfSmtImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_then_block_number = "";
        ref_else_block_number = "";
        ref_cond_expression_number = "";
        m_is_else_if = false;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R453_has_then_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R454_has_else_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R471_executes_then_block_if_true_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private IfSmtImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_then_block_number, String ref_else_block_number, String ref_cond_expression_number, boolean m_is_else_if ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_then_block_number = ref_then_block_number;
        this.ref_else_block_number = ref_else_block_number;
        this.ref_cond_expression_number = ref_cond_expression_number;
        this.m_is_else_if = m_is_else_if;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R453_has_then_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R454_has_else_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R471_executes_then_block_if_true_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static IfSmt create( Sql context ) throws XtumlException {
        IfSmt newIfSmt = new IfSmtImpl( context );
        if ( context.addInstance( newIfSmt ) ) {
            newIfSmt.getRunContext().addChange(new InstanceCreatedDelta(newIfSmt, KEY_LETTERS));
            return newIfSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static IfSmt create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_then_block_number, String ref_else_block_number, String ref_cond_expression_number, boolean m_is_else_if ) throws XtumlException {
        IfSmt newIfSmt = new IfSmtImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_then_block_number, ref_else_block_number, ref_cond_expression_number, m_is_else_if );
        if ( context.addInstance( newIfSmt ) ) {
            return newIfSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_then_block_number;
    @Override
    public String getThen_block_number() throws XtumlException {
        checkLiving();
        return ref_then_block_number;
    }
    @Override
    public void setThen_block_number(String ref_then_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_then_block_number, this.ref_then_block_number)) {
            final String oldValue = this.ref_then_block_number;
            this.ref_then_block_number = ref_then_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_then_block_number", oldValue, this.ref_then_block_number));
        }
    }
    private String ref_else_block_number;
    @Override
    public String getElse_block_number() throws XtumlException {
        checkLiving();
        return ref_else_block_number;
    }
    @Override
    public void setElse_block_number(String ref_else_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_else_block_number, this.ref_else_block_number)) {
            final String oldValue = this.ref_else_block_number;
            this.ref_else_block_number = ref_else_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_else_block_number", oldValue, this.ref_else_block_number));
        }
    }
    private String ref_cond_expression_number;
    @Override
    public String getCond_expression_number() throws XtumlException {
        checkLiving();
        return ref_cond_expression_number;
    }
    @Override
    public void setCond_expression_number(String ref_cond_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_cond_expression_number, this.ref_cond_expression_number)) {
            final String oldValue = this.ref_cond_expression_number;
            this.ref_cond_expression_number = ref_cond_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_cond_expression_number", oldValue, this.ref_cond_expression_number));
        }
    }
    private boolean m_is_else_if;
    @Override
    public boolean getIs_else_if() throws XtumlException {
        checkLiving();
        return m_is_else_if;
    }
    @Override
    public void setIs_else_if(boolean m_is_else_if) throws XtumlException {
        checkLiving();
        if (m_is_else_if != this.m_is_else_if) {
            final boolean oldValue = this.m_is_else_if;
            this.m_is_else_if = m_is_else_if;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_else_if", oldValue, this.m_is_else_if));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Statement smt = self().R451_is_a_Statement();
        String if_oal = "";
        IfSmt enclosing_else = smt.R450_is_contained_by_CodeBlock().R454_controls_else_for_IfSmt();
        StatementSet sibling_smts = smt.R450_is_contained_by_CodeBlock().R450_is_scope_for_Statement();
        if ( enclosing_else.isEmpty() || sibling_smts.size() != 1 ) {
            if_oal = "";
        }
        String else_oal = "";
        StatementSet child_smts = self().R454_has_else_CodeBlock().R450_is_scope_for_Statement();
        IfSmt child_if = child_smts.R451_is_a_IfSmt().any();
        if ( child_smts.size() == 1 && !child_if.isEmpty() ) {
            else_oal = "";
        }
        Expression cond_expression = self().R471_executes_then_block_if_true_Expression();
        cond_expression.render();
        String cond_expr = context().T().body();
        context().T().clear();
        CodeBlock then_blk = self().R453_has_then_CodeBlock();
        then_blk.render();
        String then_block = context().T().body();
        context().T().clear();
        CodeBlock else_blk = self().R454_has_else_CodeBlock();
        String else_block = "";
        if ( !else_blk.isEmpty() ) {
            else_blk.render();
            else_block = context().T().body();
            context().T().clear();
        }
        CodeBlock enclosing_block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( enclosing_block.getTab_depth() + 1 );
        context().T().pop_buffer();
        context().T().include( "statement/t.if.java", cond_expr, else_block, else_oal, if_oal, indent, self(), then_block );
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }
    private CodeBlock R453_has_then_CodeBlock_inst;
    @Override
    public void setR453_has_then_CodeBlock( CodeBlock inst ) {
        R453_has_then_CodeBlock_inst = inst;
    }
    @Override
    public CodeBlock R453_has_then_CodeBlock() throws XtumlException {
        return R453_has_then_CodeBlock_inst;
    }
    private CodeBlock R454_has_else_CodeBlock_inst;
    @Override
    public void setR454_has_else_CodeBlock( CodeBlock inst ) {
        R454_has_else_CodeBlock_inst = inst;
    }
    @Override
    public CodeBlock R454_has_else_CodeBlock() throws XtumlException {
        return R454_has_else_CodeBlock_inst;
    }
    private Expression R471_executes_then_block_if_true_Expression_inst;
    @Override
    public void setR471_executes_then_block_if_true_Expression( Expression inst ) {
        R471_executes_then_block_if_true_Expression_inst = inst;
    }
    @Override
    public Expression R471_executes_then_block_if_true_Expression() throws XtumlException {
        return R471_executes_then_block_if_true_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public IfSmt self() {
        return this;
    }

    @Override
    public IfSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_IFSMT;
    }

}

class EmptyIfSmt extends ModelInstance<IfSmt,Sql> implements IfSmt {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getThen_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setThen_block_number( String ref_then_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getElse_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setElse_block_number( String ref_else_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getCond_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCond_expression_number( String ref_cond_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_else_if() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_else_if( boolean m_is_else_if ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public CodeBlock R453_has_then_CodeBlock() {
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }
    @Override
    public CodeBlock R454_has_else_CodeBlock() {
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }
    @Override
    public Expression R471_executes_then_block_if_true_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return IfSmtImpl.KEY_LETTERS;
    }

    @Override
    public IfSmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public IfSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return IfSmtImpl.EMPTY_IFSMT;
    }

}
