package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.invocable.impl.CodeBlockImpl;
import io.ciera.tool.sql.architecture.statement.ForSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.Variable;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;


public class ForSmtImpl extends ModelInstance<ForSmt,Sql> implements ForSmt {

    public static final String KEY_LETTERS = "ForSmt";
    public static final ForSmt EMPTY_FORSMT = new EmptyForSmt();

    private Sql context;

    // constructors
    private ForSmtImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_control_block_number = "";
        ref_iterator_name = "";
        ref_iterator_block_number = "";
        ref_iterable_expression_number = "";
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R455_has_control_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R459_declares_as_iterator_Variable_inst = VariableImpl.EMPTY_VARIABLE;
        R478_iterates_over_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private ForSmtImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_control_block_number, String ref_iterator_name, String ref_iterator_block_number, String ref_iterable_expression_number ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_control_block_number = ref_control_block_number;
        this.ref_iterator_name = ref_iterator_name;
        this.ref_iterator_block_number = ref_iterator_block_number;
        this.ref_iterable_expression_number = ref_iterable_expression_number;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R455_has_control_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R459_declares_as_iterator_Variable_inst = VariableImpl.EMPTY_VARIABLE;
        R478_iterates_over_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static ForSmt create( Sql context ) throws XtumlException {
        ForSmt newForSmt = new ForSmtImpl( context );
        if ( context.addInstance( newForSmt ) ) {
            newForSmt.getRunContext().addChange(new InstanceCreatedDelta(newForSmt, KEY_LETTERS));
            return newForSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ForSmt create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_control_block_number, String ref_iterator_name, String ref_iterator_block_number, String ref_iterable_expression_number ) throws XtumlException {
        ForSmt newForSmt = new ForSmtImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_control_block_number, ref_iterator_name, ref_iterator_block_number, ref_iterable_expression_number );
        if ( context.addInstance( newForSmt ) ) {
            return newForSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_control_block_number;
    @Override
    public String getControl_block_number() throws XtumlException {
        checkLiving();
        return ref_control_block_number;
    }
    @Override
    public void setControl_block_number(String ref_control_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_control_block_number, this.ref_control_block_number)) {
            final String oldValue = this.ref_control_block_number;
            this.ref_control_block_number = ref_control_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_control_block_number", oldValue, this.ref_control_block_number));
        }
    }
    private String ref_iterator_name;
    @Override
    public void setIterator_name(String ref_iterator_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iterator_name, this.ref_iterator_name)) {
            final String oldValue = this.ref_iterator_name;
            this.ref_iterator_name = ref_iterator_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iterator_name", oldValue, this.ref_iterator_name));
        }
    }
    @Override
    public String getIterator_name() throws XtumlException {
        checkLiving();
        return ref_iterator_name;
    }
    private String ref_iterator_block_number;
    @Override
    public String getIterator_block_number() throws XtumlException {
        checkLiving();
        return ref_iterator_block_number;
    }
    @Override
    public void setIterator_block_number(String ref_iterator_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iterator_block_number, this.ref_iterator_block_number)) {
            final String oldValue = this.ref_iterator_block_number;
            this.ref_iterator_block_number = ref_iterator_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iterator_block_number", oldValue, this.ref_iterator_block_number));
        }
    }
    private String ref_iterable_expression_number;
    @Override
    public void setIterable_expression_number(String ref_iterable_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iterable_expression_number, this.ref_iterable_expression_number)) {
            final String oldValue = this.ref_iterable_expression_number;
            this.ref_iterable_expression_number = ref_iterable_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iterable_expression_number", oldValue, this.ref_iterable_expression_number));
        }
    }
    @Override
    public String getIterable_expression_number() throws XtumlException {
        checkLiving();
        return ref_iterable_expression_number;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void initializeIterator() throws XtumlException {
        CodeBlock enclosing_block = self().R451_is_a_Statement().R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( enclosing_block.getTab_depth() + 2 );
        CodeBlock control_blk = self().R455_has_control_CodeBlock();
        context().T().include( "statement/t.for.iter.java", indent, self() );
        control_blk.setPrefix(context().T().body());
        context().T().clear();
    }

    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Statement smt = self().R451_is_a_Statement();
        String oal = smt.getOal();
        String prefix = smt.getPrefix();
        TypeReference iter_type = self().R459_declares_as_iterator_Variable().R461_is_typed_by_TypeReference();
        String iterator_type = iter_type.getType_reference_name();
        Expression iterable_expression = self().R478_iterates_over_Expression();
        iterable_expression.render();
        String iterable_expr = context().T().body();
        context().T().clear();
        CodeBlock control_blk = self().R455_has_control_CodeBlock();
        control_blk.render();
        String control_block = context().T().body();
        context().T().clear();
        CodeBlock enclosing_block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( enclosing_block.getTab_depth() + 1 );
        Statement declaration_smt = self().R459_declares_as_iterator_Variable().R457_is_declared_by_Statement();
        if ( StringUtil.equality(declaration_smt.getStatement_number(), self().getStatement_number()) && StringUtil.equality(declaration_smt.getBlock_number(), self().getBlock_number()) ) {
            TypeReference var_type = self().R459_declares_as_iterator_Variable().R461_is_typed_by_TypeReference();
            prefix = ( ( ( ( prefix + indent ) + var_type.getType_reference_name() ) + " " ) + self().getIterator_name() ) + ";\n";
        }
        context().T().pop_buffer();
        context().T().include( "statement/t.for.java", control_block, indent, iterable_expr, iterator_type, oal, prefix, self() );
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }
    private CodeBlock R455_has_control_CodeBlock_inst;
    @Override
    public void setR455_has_control_CodeBlock( CodeBlock inst ) {
        R455_has_control_CodeBlock_inst = inst;
    }
    @Override
    public CodeBlock R455_has_control_CodeBlock() throws XtumlException {
        return R455_has_control_CodeBlock_inst;
    }
    private Variable R459_declares_as_iterator_Variable_inst;
    @Override
    public void setR459_declares_as_iterator_Variable( Variable inst ) {
        R459_declares_as_iterator_Variable_inst = inst;
    }
    @Override
    public Variable R459_declares_as_iterator_Variable() throws XtumlException {
        return R459_declares_as_iterator_Variable_inst;
    }
    private Expression R478_iterates_over_Expression_inst;
    @Override
    public void setR478_iterates_over_Expression( Expression inst ) {
        R478_iterates_over_Expression_inst = inst;
    }
    @Override
    public Expression R478_iterates_over_Expression() throws XtumlException {
        return R478_iterates_over_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ForSmt self() {
        return this;
    }

    @Override
    public ForSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FORSMT;
    }

}

class EmptyForSmt extends ModelInstance<ForSmt,Sql> implements ForSmt {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getControl_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setControl_block_number( String ref_control_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIterator_name( String ref_iterator_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getIterator_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getIterator_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIterator_block_number( String ref_iterator_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIterable_expression_number( String ref_iterable_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getIterable_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void initializeIterator() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public CodeBlock R455_has_control_CodeBlock() {
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }
    @Override
    public Variable R459_declares_as_iterator_Variable() {
        return VariableImpl.EMPTY_VARIABLE;
    }
    @Override
    public Expression R478_iterates_over_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return ForSmtImpl.KEY_LETTERS;
    }

    @Override
    public ForSmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ForSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ForSmtImpl.EMPTY_FORSMT;
    }

}
