package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.statement.DeleteSmt;
import io.ciera.tool.sql.architecture.statement.DeleteSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class DeleteSmtSetImpl extends InstanceSet<DeleteSmtSet,DeleteSmt> implements DeleteSmtSet {

    public DeleteSmtSetImpl() {
    }

    public DeleteSmtSetImpl(Comparator<? super DeleteSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( DeleteSmt deletesmt : this ) deletesmt.setExpression_number( ref_expression_number );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( DeleteSmt deletesmt : this ) deletesmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( DeleteSmt deletesmt : this ) deletesmt.setStatement_number( ref_statement_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( DeleteSmt deletesmt : this ) deletesmt.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( DeleteSmt deletesmt : this ) deletesmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( DeleteSmt deletesmt : this ) deletesmt.setParent_name( ref_parent_name );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( DeleteSmt deletesmt : this ) statementset.add( deletesmt.R451_is_a_Statement() );
        return statementset;
    }
    @Override
    public ExpressionSet R462_deletes_instance_specified_by_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( DeleteSmt deletesmt : this ) expressionset.add( deletesmt.R462_deletes_instance_specified_by_Expression() );
        return expressionset;
    }


    @Override
    public DeleteSmt nullElement() {
        return DeleteSmtImpl.EMPTY_DELETESMT;
    }

    @Override
    public DeleteSmtSet emptySet() {
      return new DeleteSmtSetImpl();
    }

    @Override
    public DeleteSmtSet emptySet(Comparator<? super DeleteSmt> comp) {
      return new DeleteSmtSetImpl(comp);
    }

    @Override
    public List<DeleteSmt> elements() {
        return Arrays.asList(toArray(new DeleteSmt[0]));
    }

}
