package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.StateTransition;
import io.ciera.tool.sql.architecture.statemachine.StateTransitionSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRow;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateTransitionSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableRowImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineState;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineStateImpl;

import java.util.Iterator;


public class StateImpl extends ModelInstance<State,Sql> implements State {

    public static final String KEY_LETTERS = "State";
    public static final State EMPTY_STATE = new EmptyState();

    private Sql context;

    // constructors
    private StateImpl( Sql context ) {
        this.context = context;
        ref_sm_name = "";
        ref_sm_package = "";
        ref_name = "";
        m_final = false;
        m_number = 0;
        ref_SM_ID = UniqueId.random();
        ref_SMstt_ID = UniqueId.random();
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4751_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R4754_is_start_state_for_TransitionTableRow_inst = TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
        R4757_StateTransition_set = new StateTransitionSetImpl();
        R4758_is_basis_for_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }

    private StateImpl( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_name, boolean m_final, int m_number, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_sm_name = ref_sm_name;
        this.ref_sm_package = ref_sm_package;
        this.ref_name = ref_name;
        this.m_final = m_final;
        this.m_number = m_number;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMstt_ID = ref_SMstt_ID;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4751_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R4754_is_start_state_for_TransitionTableRow_inst = TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
        R4757_StateTransition_set = new StateTransitionSetImpl();
        R4758_is_basis_for_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }

    public static State create( Sql context ) throws XtumlException {
        State newState = new StateImpl( context );
        if ( context.addInstance( newState ) ) {
            newState.getRunContext().addChange(new InstanceCreatedDelta(newState, KEY_LETTERS));
            return newState;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static State create( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_name, boolean m_final, int m_number, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID ) throws XtumlException {
        State newState = new StateImpl( context, instanceId, ref_sm_name, ref_sm_package, ref_name, m_final, m_number, ref_SM_ID, ref_SMstt_ID );
        if ( context.addInstance( newState ) ) {
            return newState;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_sm_name;
    @Override
    public String getSm_name() throws XtumlException {
        checkLiving();
        return ref_sm_name;
    }
    @Override
    public void setSm_name(String ref_sm_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_sm_name, this.ref_sm_name)) {
            final String oldValue = this.ref_sm_name;
            this.ref_sm_name = ref_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_name", oldValue, this.ref_sm_name));
            if ( !R4754_is_start_state_for_TransitionTableRow().isEmpty() ) R4754_is_start_state_for_TransitionTableRow().setSm_name( ref_sm_name );
            if ( !R4757_StateTransition().isEmpty() ) R4757_StateTransition().setSm_name( ref_sm_name );
        }
    }
    private String ref_sm_package;
    @Override
    public String getSm_package() throws XtumlException {
        checkLiving();
        return ref_sm_package;
    }
    @Override
    public void setSm_package(String ref_sm_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_sm_package, this.ref_sm_package)) {
            final String oldValue = this.ref_sm_package;
            this.ref_sm_package = ref_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_package", oldValue, this.ref_sm_package));
            if ( !R4754_is_start_state_for_TransitionTableRow().isEmpty() ) R4754_is_start_state_for_TransitionTableRow().setSm_package( ref_sm_package );
            if ( !R4757_StateTransition().isEmpty() ) R4757_StateTransition().setSm_package( ref_sm_package );
        }
    }
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4757_StateTransition().isEmpty() ) R4757_StateTransition().setEnd_state_name( ref_name );
            if ( !R4754_is_start_state_for_TransitionTableRow().isEmpty() ) R4754_is_start_state_for_TransitionTableRow().setState_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    private boolean m_final;
    @Override
    public boolean getFinal() throws XtumlException {
        checkLiving();
        return m_final;
    }
    @Override
    public void setFinal(boolean m_final) throws XtumlException {
        checkLiving();
        if (m_final != this.m_final) {
            final boolean oldValue = this.m_final;
            this.m_final = m_final;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_final", oldValue, this.m_final));
        }
    }
    private int m_number;
    @Override
    public int getNumber() throws XtumlException {
        checkLiving();
        return m_number;
    }
    @Override
    public void setNumber(int m_number) throws XtumlException {
        checkLiving();
        if (m_number != this.m_number) {
            final int oldValue = this.m_number;
            this.m_number = m_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_number", oldValue, this.m_number));
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId ref_SMstt_ID;
    @Override
    public void setSMstt_ID(UniqueId ref_SMstt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMstt_ID.inequality( this.ref_SMstt_ID)) {
            final UniqueId oldValue = this.ref_SMstt_ID;
            this.ref_SMstt_ID = ref_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMstt_ID", oldValue, this.ref_SMstt_ID));
        }
    }
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
        return ref_SMstt_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSm_name(), getSm_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        String parameter_list = "";
        InvocableObject evt_invocable = self().R4757_StateTransition().R4757_TransitionTableCell().R4756_receives_Event().R427_is_a_InvocableObject().any();
        if ( !evt_invocable.isEmpty() ) {
            boolean same_data_ok = true;
            InvocableObjectSet evt_invocables = self().R4757_StateTransition().R4757_TransitionTableCell().R4756_receives_Event().R427_is_a_InvocableObject();
            InvocableObject other_evt_invocable;
            for ( Iterator<InvocableObject> _other_evt_invocable_iter = evt_invocables.elements().iterator(); _other_evt_invocable_iter.hasNext(); ) {
                other_evt_invocable = _other_evt_invocable_iter.next();
                if ( StringUtil.inequality(evt_invocable.get_signature(), other_evt_invocable.get_signature()) ) {
                    same_data_ok = false;
                    break;
                }
            }
            if ( same_data_ok ) {
                parameter_list = evt_invocable.parameter_list();
            }
        }
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String body = invocable.body();
        context().T().pop_buffer();
        context().T().include( "statemachine/t.state.java", body, parameter_list, self() );
    }

    @Override
    public void render_decl() throws XtumlException {
        context().T().include( "statemachine/t.state.decl.java", self() );
    }



    // static operations


    // events


    // selections
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }
    private StateMachine R4751_StateMachine_inst;
    @Override
    public void setR4751_StateMachine( StateMachine inst ) {
        R4751_StateMachine_inst = inst;
    }
    @Override
    public StateMachine R4751_StateMachine() throws XtumlException {
        return R4751_StateMachine_inst;
    }
    private TransitionTableRow R4754_is_start_state_for_TransitionTableRow_inst;
    @Override
    public void setR4754_is_start_state_for_TransitionTableRow( TransitionTableRow inst ) {
        R4754_is_start_state_for_TransitionTableRow_inst = inst;
    }
    @Override
    public TransitionTableRow R4754_is_start_state_for_TransitionTableRow() throws XtumlException {
        return R4754_is_start_state_for_TransitionTableRow_inst;
    }
    private StateTransitionSet R4757_StateTransition_set;
    @Override
    public void addR4757_StateTransition( StateTransition inst ) {
        R4757_StateTransition_set.add(inst);
    }
    @Override
    public void removeR4757_StateTransition( StateTransition inst ) {
        R4757_StateTransition_set.remove(inst);
    }
    @Override
    public StateTransitionSet R4757_StateTransition() throws XtumlException {
        return R4757_StateTransition_set;
    }
    private StateMachineState R4758_is_basis_for_StateMachineState_inst;
    @Override
    public void setR4758_is_basis_for_StateMachineState( StateMachineState inst ) {
        R4758_is_basis_for_StateMachineState_inst = inst;
    }
    @Override
    public StateMachineState R4758_is_basis_for_StateMachineState() throws XtumlException {
        return R4758_is_basis_for_StateMachineState_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public State self() {
        return this;
    }

    @Override
    public State oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STATE;
    }

}

class EmptyState extends ModelInstance<State,Sql> implements State {

    // attributes
    public String getSm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getFinal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFinal( boolean m_final ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumber( int m_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_decl() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public StateMachine R4751_StateMachine() {
        return StateMachineImpl.EMPTY_STATEMACHINE;
    }
    @Override
    public TransitionTableRow R4754_is_start_state_for_TransitionTableRow() {
        return TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
    }
    @Override
    public StateTransitionSet R4757_StateTransition() {
        return (new StateTransitionSetImpl());
    }
    @Override
    public StateMachineState R4758_is_basis_for_StateMachineState() {
        return StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }


    @Override
    public String getKeyLetters() {
        return StateImpl.KEY_LETTERS;
    }

    @Override
    public State self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public State oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StateImpl.EMPTY_STATE;
    }

}
