package io.ciera.tool.sql.architecture.interfaces.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.interfaces.Iface;
import io.ciera.tool.sql.architecture.interfaces.Message;
import io.ciera.tool.sql.architecture.interfaces.PortMessage;
import io.ciera.tool.sql.architecture.interfaces.PortMessageSet;
import io.ciera.tool.sql.architecture.interfaces.impl.IfaceImpl;
import io.ciera.tool.sql.architecture.interfaces.impl.PortMessageSetImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterImpl;


public class MessageImpl extends ModelInstance<Message,Sql> implements Message {

    public static final String KEY_LETTERS = "Message";
    public static final Message EMPTY_MESSAGE = new EmptyMessage();

    private Sql context;

    // constructors
    private MessageImpl( Sql context ) {
        this.context = context;
        ref_iface_name = "";
        ref_iface_package = "";
        m_name = "";
        m_to_provider = false;
        m_id = 0;
        R419_defines_message_format_for_Iface_inst = IfaceImpl.EMPTY_IFACE;
        R420_is_implemented_within_PortMessage_set = new PortMessageSetImpl();
    }

    private MessageImpl( Sql context, UniqueId instanceId, String ref_iface_name, String ref_iface_package, String m_name, boolean m_to_provider, int m_id ) {
        super(instanceId);
        this.context = context;
        this.ref_iface_name = ref_iface_name;
        this.ref_iface_package = ref_iface_package;
        this.m_name = m_name;
        this.m_to_provider = m_to_provider;
        this.m_id = m_id;
        R419_defines_message_format_for_Iface_inst = IfaceImpl.EMPTY_IFACE;
        R420_is_implemented_within_PortMessage_set = new PortMessageSetImpl();
    }

    public static Message create( Sql context ) throws XtumlException {
        Message newMessage = new MessageImpl( context );
        if ( context.addInstance( newMessage ) ) {
            newMessage.getRunContext().addChange(new InstanceCreatedDelta(newMessage, KEY_LETTERS));
            return newMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Message create( Sql context, UniqueId instanceId, String ref_iface_name, String ref_iface_package, String m_name, boolean m_to_provider, int m_id ) throws XtumlException {
        Message newMessage = new MessageImpl( context, instanceId, ref_iface_name, ref_iface_package, m_name, m_to_provider, m_id );
        if ( context.addInstance( newMessage ) ) {
            return newMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_iface_name;
    @Override
    public String getIface_name() throws XtumlException {
        checkLiving();
        return ref_iface_name;
    }
    @Override
    public void setIface_name(String ref_iface_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iface_name, this.ref_iface_name)) {
            final String oldValue = this.ref_iface_name;
            this.ref_iface_name = ref_iface_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iface_name", oldValue, this.ref_iface_name));
            if ( !R420_is_implemented_within_PortMessage().isEmpty() ) R420_is_implemented_within_PortMessage().setIface_name( ref_iface_name );
        }
    }
    private String ref_iface_package;
    @Override
    public void setIface_package(String ref_iface_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iface_package, this.ref_iface_package)) {
            final String oldValue = this.ref_iface_package;
            this.ref_iface_package = ref_iface_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iface_package", oldValue, this.ref_iface_package));
            if ( !R420_is_implemented_within_PortMessage().isEmpty() ) R420_is_implemented_within_PortMessage().setIface_package( ref_iface_package );
        }
    }
    @Override
    public String getIface_package() throws XtumlException {
        checkLiving();
        return ref_iface_package;
    }
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R420_is_implemented_within_PortMessage().isEmpty() ) R420_is_implemented_within_PortMessage().setMsg_name( m_name );
        }
    }
    private boolean m_to_provider;
    @Override
    public boolean getTo_provider() throws XtumlException {
        checkLiving();
        return m_to_provider;
    }
    @Override
    public void setTo_provider(boolean m_to_provider) throws XtumlException {
        checkLiving();
        if (m_to_provider != this.m_to_provider) {
            final boolean oldValue = this.m_to_provider;
            this.m_to_provider = m_to_provider;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_to_provider", oldValue, this.m_to_provider));
        }
    }
    private int m_id;
    @Override
    public int getId() throws XtumlException {
        checkLiving();
        return m_id;
    }
    @Override
    public void setId(int m_id) throws XtumlException {
        checkLiving();
        if (m_id != this.m_id) {
            final int oldValue = this.m_id;
            this.m_id = m_id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_id", oldValue, this.m_id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getIface_name(), getIface_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        InvocableObject invocable = self().R420_is_implemented_within_PortMessage().R427_is_a_InvocableObject().any();
        String parameter_list = invocable.parameter_list();
        String invocation_parameter_list = "";
        FormalParameter parm = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        FormalParameter prev_parm = invocable.R429_declares_signature_with_FormalParameter().any();
        while ( !prev_parm.isEmpty() ) {
            parm = prev_parm;
            prev_parm = parm.R404_follows_FormalParameter();
        }
        String separator = "";
        while ( !parm.isEmpty() ) {
            invocation_parameter_list = ( invocation_parameter_list + separator ) + parm.getName();
            separator = ",  ";
            parm = parm.R404_precedes_FormalParameter();
        }
        context().T().include( "interface/t.message.java", invocation_parameter_list, parameter_list, self() );
    }



    // static operations


    // events


    // selections
    private Iface R419_defines_message_format_for_Iface_inst;
    @Override
    public void setR419_defines_message_format_for_Iface( Iface inst ) {
        R419_defines_message_format_for_Iface_inst = inst;
    }
    @Override
    public Iface R419_defines_message_format_for_Iface() throws XtumlException {
        return R419_defines_message_format_for_Iface_inst;
    }
    private PortMessageSet R420_is_implemented_within_PortMessage_set;
    @Override
    public void addR420_is_implemented_within_PortMessage( PortMessage inst ) {
        R420_is_implemented_within_PortMessage_set.add(inst);
    }
    @Override
    public void removeR420_is_implemented_within_PortMessage( PortMessage inst ) {
        R420_is_implemented_within_PortMessage_set.remove(inst);
    }
    @Override
    public PortMessageSet R420_is_implemented_within_PortMessage() throws XtumlException {
        return R420_is_implemented_within_PortMessage_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Message self() {
        return this;
    }

    @Override
    public Message oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MESSAGE;
    }

}

class EmptyMessage extends ModelInstance<Message,Sql> implements Message {

    // attributes
    public String getIface_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIface_name( String ref_iface_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIface_package( String ref_iface_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getIface_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getTo_provider() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTo_provider( boolean m_to_provider ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( int m_id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Iface R419_defines_message_format_for_Iface() {
        return IfaceImpl.EMPTY_IFACE;
    }
    @Override
    public PortMessageSet R420_is_implemented_within_PortMessage() {
        return (new PortMessageSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return MessageImpl.KEY_LETTERS;
    }

    @Override
    public Message self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Message oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MessageImpl.EMPTY_MESSAGE;
    }

}
