package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ActualParameterSet;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.Invocation;
import io.ciera.tool.sql.architecture.expression.InvocationSet;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class InvocationSetImpl extends InstanceSet<InvocationSet,Invocation> implements InvocationSet {

    public InvocationSetImpl() {
    }

    public InvocationSetImpl(Comparator<? super Invocation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setBody_name( ref_body_name );
    }
    @Override
    public void setInvoked_parent_name( String ref_invoked_parent_name ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setInvoked_parent_name( ref_invoked_parent_name );
    }
    @Override
    public void setInvoked_parent_package( String ref_invoked_parent_package ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setInvoked_parent_package( ref_invoked_parent_package );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setBlock_number( ref_block_number );
    }
    @Override
    public void setBase_expression_number( String ref_base_expression_number ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setBase_expression_number( ref_base_expression_number );
    }
    @Override
    public void setInvoked_name( String ref_invoked_name ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setInvoked_name( ref_invoked_name );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setParent_package( ref_parent_package );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( Invocation invocation : this ) invocation.setExpression_number( ref_expression_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Invocation invocation : this ) expressionset.add( invocation.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public InvocableObjectSet R792_invokes_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( Invocation invocation : this ) invocableobjectset.add( invocation.R792_invokes_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public ActualParameterSet R793_ActualParameter() throws XtumlException {
        ActualParameterSet actualparameterset = new ActualParameterSetImpl();
        for ( Invocation invocation : this ) actualparameterset.addAll( invocation.R793_ActualParameter() );
        return actualparameterset;
    }
    @Override
    public ExpressionSet R798_invokes_activity_on_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Invocation invocation : this ) expressionset.add( invocation.R798_invokes_activity_on_Expression() );
        return expressionset;
    }


    @Override
    public Invocation nullElement() {
        return InvocationImpl.EMPTY_INVOCATION;
    }

    @Override
    public InvocationSet emptySet() {
      return new InvocationSetImpl();
    }

    @Override
    public InvocationSet emptySet(Comparator<? super Invocation> comp) {
      return new InvocationSetImpl(comp);
    }

    @Override
    public List<Invocation> elements() {
        return Arrays.asList(toArray(new Invocation[0]));
    }

}
