package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.EventCreation;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;


public class EventCreationImpl extends ModelInstance<EventCreation,Sql> implements EventCreation {

    public static final String KEY_LETTERS = "EventCreation";
    public static final EventCreation EMPTY_EVENTCREATION = new EmptyEventCreation();

    private Sql context;

    // constructors
    private EventCreationImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_target_expression_number = "";
        ref_evt_expression_number = "";
        m_to_self = false;
        R3902_has_target_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R3903_has_base_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private EventCreationImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_target_expression_number, String ref_evt_expression_number, boolean m_to_self ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_target_expression_number = ref_target_expression_number;
        this.ref_evt_expression_number = ref_evt_expression_number;
        this.m_to_self = m_to_self;
        R3902_has_target_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R3903_has_base_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static EventCreation create( Sql context ) throws XtumlException {
        EventCreation newEventCreation = new EventCreationImpl( context );
        if ( context.addInstance( newEventCreation ) ) {
            newEventCreation.getRunContext().addChange(new InstanceCreatedDelta(newEventCreation, KEY_LETTERS));
            return newEventCreation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventCreation create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_target_expression_number, String ref_evt_expression_number, boolean m_to_self ) throws XtumlException {
        EventCreation newEventCreation = new EventCreationImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_target_expression_number, ref_evt_expression_number, m_to_self );
        if ( context.addInstance( newEventCreation ) ) {
            return newEventCreation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    private String ref_target_expression_number;
    @Override
    public String getTarget_expression_number() throws XtumlException {
        checkLiving();
        return ref_target_expression_number;
    }
    @Override
    public void setTarget_expression_number(String ref_target_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_target_expression_number, this.ref_target_expression_number)) {
            final String oldValue = this.ref_target_expression_number;
            this.ref_target_expression_number = ref_target_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_target_expression_number", oldValue, this.ref_target_expression_number));
        }
    }
    private String ref_evt_expression_number;
    @Override
    public void setEvt_expression_number(String ref_evt_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_evt_expression_number, this.ref_evt_expression_number)) {
            final String oldValue = this.ref_evt_expression_number;
            this.ref_evt_expression_number = ref_evt_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_evt_expression_number", oldValue, this.ref_evt_expression_number));
        }
    }
    @Override
    public String getEvt_expression_number() throws XtumlException {
        checkLiving();
        return ref_evt_expression_number;
    }
    private boolean m_to_self;
    @Override
    public void setTo_self(boolean m_to_self) throws XtumlException {
        checkLiving();
        if (m_to_self != this.m_to_self) {
            final boolean oldValue = this.m_to_self;
            this.m_to_self = m_to_self;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_to_self", oldValue, this.m_to_self));
        }
    }
    @Override
    public boolean getTo_self() throws XtumlException {
        checkLiving();
        return m_to_self;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Expression evt_expression = self().R3903_has_base_Expression();
        evt_expression.render();
        String evt_expr = context().T().body();
        context().T().clear();
        Expression target_expression = self().R3902_has_target_Expression();
        target_expression.render();
        String target_expr = context().T().body();
        context().T().pop_buffer();
        context().T().include( "expression/t.eventcreation.java", evt_expr, self(), target_expr );
    }



    // static operations


    // events


    // selections
    private Expression R3902_has_target_Expression_inst;
    @Override
    public void setR3902_has_target_Expression( Expression inst ) {
        R3902_has_target_Expression_inst = inst;
    }
    @Override
    public Expression R3902_has_target_Expression() throws XtumlException {
        return R3902_has_target_Expression_inst;
    }
    private Expression R3903_has_base_Expression_inst;
    @Override
    public void setR3903_has_base_Expression( Expression inst ) {
        R3903_has_base_Expression_inst = inst;
    }
    @Override
    public Expression R3903_has_base_Expression() throws XtumlException {
        return R3903_has_base_Expression_inst;
    }
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventCreation self() {
        return this;
    }

    @Override
    public EventCreation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTCREATION;
    }

}

class EmptyEventCreation extends ModelInstance<EventCreation,Sql> implements EventCreation {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getTarget_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTarget_expression_number( String ref_target_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setEvt_expression_number( String ref_evt_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvt_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTo_self( boolean m_to_self ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getTo_self() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Expression R3902_has_target_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R3903_has_base_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return EventCreationImpl.KEY_LETTERS;
    }

    @Override
    public EventCreation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventCreation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventCreationImpl.EMPTY_EVENTCREATION;
    }

}
