package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ActualParameter;
import io.ciera.tool.sql.architecture.expression.ActualParameterSet;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.InvocationSet;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.InvocationSetImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameterSet;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ActualParameterSetImpl extends InstanceSet<ActualParameterSet,ActualParameter> implements ActualParameterSet {

    public ActualParameterSetImpl() {
    }

    public ActualParameterSetImpl(Comparator<? super ActualParameter> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setParam_name( String ref_param_name ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setParam_name( ref_param_name );
    }
    @Override
    public void setInvoked_name( String ref_invoked_name ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setInvoked_name( ref_invoked_name );
    }
    @Override
    public void setInvocation_expression_number( String ref_invocation_expression_number ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setInvocation_expression_number( ref_invocation_expression_number );
    }
    @Override
    public void setInvoked_parent_name( String ref_invoked_parent_name ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setInvoked_parent_name( ref_invoked_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setParent_package( ref_parent_package );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setParent_name( ref_parent_name );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setExpression_number( ref_expression_number );
    }
    @Override
    public void setInvoked_parent_package( String ref_invoked_parent_package ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setInvoked_parent_package( ref_invoked_parent_package );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setStatement_number( ref_statement_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setBody_name( ref_body_name );
    }
    @Override
    public void setNext_expression_number( String ref_next_expression_number ) throws XtumlException {
        for ( ActualParameter actualparameter : this ) actualparameter.setNext_expression_number( ref_next_expression_number );
    }


    // selections
    @Override
    public FormalParameterSet R3904_FormalParameter() throws XtumlException {
        FormalParameterSet formalparameterset = new FormalParameterSetImpl();
        for ( ActualParameter actualparameter : this ) formalparameterset.add( actualparameter.R3904_FormalParameter() );
        return formalparameterset;
    }
    @Override
    public ActualParameterSet R3905_follows_ActualParameter() throws XtumlException {
        ActualParameterSet actualparameterset = new ActualParameterSetImpl();
        for ( ActualParameter actualparameter : this ) actualparameterset.add( actualparameter.R3905_follows_ActualParameter() );
        return actualparameterset;
    }
    @Override
    public ActualParameterSet R3905_precedes_ActualParameter() throws XtumlException {
        ActualParameterSet actualparameterset = new ActualParameterSetImpl();
        for ( ActualParameter actualparameter : this ) actualparameterset.add( actualparameter.R3905_precedes_ActualParameter() );
        return actualparameterset;
    }
    @Override
    public InvocationSet R793_Invocation() throws XtumlException {
        InvocationSet invocationset = new InvocationSetImpl();
        for ( ActualParameter actualparameter : this ) invocationset.add( actualparameter.R793_Invocation() );
        return invocationset;
    }
    @Override
    public ExpressionSet R794_parameter_value_specified_by_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( ActualParameter actualparameter : this ) expressionset.add( actualparameter.R794_parameter_value_specified_by_Expression() );
        return expressionset;
    }


    @Override
    public ActualParameter nullElement() {
        return ActualParameterImpl.EMPTY_ACTUALPARAMETER;
    }

    @Override
    public ActualParameterSet emptySet() {
      return new ActualParameterSetImpl();
    }

    @Override
    public ActualParameterSet emptySet(Comparator<? super ActualParameter> comp) {
      return new ActualParameterSetImpl(comp);
    }

    @Override
    public List<ActualParameter> elements() {
        return Arrays.asList(toArray(new ActualParameter[0]));
    }

}
