package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.UtilityFunction;
import io.ciera.tool.sql.architecture.component.impl.UtilityImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeImpl;


public class UtilityFunctionImpl extends ModelInstance<UtilityFunction,Sql> implements UtilityFunction {

    public static final String KEY_LETTERS = "UtilityFunction";
    public static final UtilityFunction EMPTY_UTILITYFUNCTION = new EmptyUtilityFunction();

    private Sql context;

    // constructors
    private UtilityFunctionImpl( Sql context ) {
        this.context = context;
        ref_utility_name = "";
        ref_utility_package = "";
        ref_name = "";
        ref_Brg_ID = UniqueId.random();
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4559_provided_by_Utility_inst = UtilityImpl.EMPTY_UTILITY;
        R4570_is_basis_for_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
    }

    private UtilityFunctionImpl( Sql context, UniqueId instanceId, String ref_utility_name, String ref_utility_package, String ref_name, UniqueId ref_Brg_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_utility_name = ref_utility_name;
        this.ref_utility_package = ref_utility_package;
        this.ref_name = ref_name;
        this.ref_Brg_ID = ref_Brg_ID;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4559_provided_by_Utility_inst = UtilityImpl.EMPTY_UTILITY;
        R4570_is_basis_for_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
    }

    public static UtilityFunction create( Sql context ) throws XtumlException {
        UtilityFunction newUtilityFunction = new UtilityFunctionImpl( context );
        if ( context.addInstance( newUtilityFunction ) ) {
            newUtilityFunction.getRunContext().addChange(new InstanceCreatedDelta(newUtilityFunction, KEY_LETTERS));
            return newUtilityFunction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UtilityFunction create( Sql context, UniqueId instanceId, String ref_utility_name, String ref_utility_package, String ref_name, UniqueId ref_Brg_ID ) throws XtumlException {
        UtilityFunction newUtilityFunction = new UtilityFunctionImpl( context, instanceId, ref_utility_name, ref_utility_package, ref_name, ref_Brg_ID );
        if ( context.addInstance( newUtilityFunction ) ) {
            return newUtilityFunction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_utility_name;
    @Override
    public void setUtility_name(String ref_utility_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_utility_name, this.ref_utility_name)) {
            final String oldValue = this.ref_utility_name;
            this.ref_utility_name = ref_utility_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_utility_name", oldValue, this.ref_utility_name));
        }
    }
    @Override
    public String getUtility_name() throws XtumlException {
        checkLiving();
        return ref_utility_name;
    }
    private String ref_utility_package;
    @Override
    public String getUtility_package() throws XtumlException {
        checkLiving();
        return ref_utility_package;
    }
    @Override
    public void setUtility_package(String ref_utility_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_utility_package, this.ref_utility_package)) {
            final String oldValue = this.ref_utility_package;
            this.ref_utility_package = ref_utility_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_utility_package", oldValue, this.ref_utility_package));
        }
    }
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    private UniqueId ref_Brg_ID;
    @Override
    public void setBrg_ID(UniqueId ref_Brg_ID) throws XtumlException {
        checkLiving();
        if (ref_Brg_ID.inequality( this.ref_Brg_ID)) {
            final UniqueId oldValue = this.ref_Brg_ID;
            this.ref_Brg_ID = ref_Brg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Brg_ID", oldValue, this.ref_Brg_ID));
        }
    }
    @Override
    public UniqueId getBrg_ID() throws XtumlException {
        checkLiving();
        return ref_Brg_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getUtility_name(), getUtility_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        TypeReference type = self().R427_is_a_InvocableObject().R428_return_value_is_typed_by_TypeReference();
        String type_name = type.getType_reference_name();
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String parameter_list = invocable.parameter_list();
        String body = invocable.body();
        if ( StringUtil.equality("{}", body) ) {
            Type return_type = type.R3800_based_on_Type();
            body = "{\n        // Insert your implementation here\n";
            if ( StringUtil.inequality("void", return_type.getName()) ) {
                body = ( ( body + "        return " ) + return_type.getDefault_value() ) + ";\n";
            }
            body = body + "    }";
        }
        context().T().include( "component/t.utilityfunction.java", body, parameter_list, self(), type_name );
    }

    @Override
    public void render_interface() throws XtumlException {
        TypeReference type = self().R427_is_a_InvocableObject().R428_return_value_is_typed_by_TypeReference();
        String type_name = type.getType_reference_name();
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String parameter_list = invocable.parameter_list();
        context().T().include( "component/t.utilityfunction.int.java", parameter_list, self(), type_name );
    }



    // static operations


    // events


    // selections
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }
    private Utility R4559_provided_by_Utility_inst;
    @Override
    public void setR4559_provided_by_Utility( Utility inst ) {
        R4559_provided_by_Utility_inst = inst;
    }
    @Override
    public Utility R4559_provided_by_Utility() throws XtumlException {
        return R4559_provided_by_Utility_inst;
    }
    private Bridge R4570_is_basis_for_Bridge_inst;
    @Override
    public void setR4570_is_basis_for_Bridge( Bridge inst ) {
        R4570_is_basis_for_Bridge_inst = inst;
    }
    @Override
    public Bridge R4570_is_basis_for_Bridge() throws XtumlException {
        return R4570_is_basis_for_Bridge_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UtilityFunction self() {
        return this;
    }

    @Override
    public UtilityFunction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_UTILITYFUNCTION;
    }

}

class EmptyUtilityFunction extends ModelInstance<UtilityFunction,Sql> implements UtilityFunction {

    // attributes
    public void setUtility_name( String ref_utility_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getUtility_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getUtility_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setUtility_package( String ref_utility_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBrg_ID( UniqueId ref_Brg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBrg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_interface() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public Utility R4559_provided_by_Utility() {
        return UtilityImpl.EMPTY_UTILITY;
    }
    @Override
    public Bridge R4570_is_basis_for_Bridge() {
        return BridgeImpl.EMPTY_BRIDGE;
    }


    @Override
    public String getKeyLetters() {
        return UtilityFunctionImpl.KEY_LETTERS;
    }

    @Override
    public UtilityFunction self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UtilityFunction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UtilityFunctionImpl.EMPTY_UTILITYFUNCTION;
    }

}
