package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.InstanceSelector;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.classes.SetSelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorImpl;
import io.ciera.tool.sql.architecture.classes.impl.SetSelectorSetImpl;
import io.ciera.tool.sql.architecture.type.Type;

import types.Cond;
import types.Mult;


public class InstanceSelectorImpl extends ModelInstance<InstanceSelector,Sql> implements InstanceSelector {

    public static final String KEY_LETTERS = "InstanceSelector";
    public static final InstanceSelector EMPTY_INSTANCESELECTOR = new EmptyInstanceSelector();

    private Sql context;

    // constructors
    private InstanceSelectorImpl( Sql context ) {
        this.context = context;
        ref_class_name = "";
        ref_class_package = "";
        ref_name = "";
        m_rel_num = 0;
        m_conditionality = Cond.UNINITIALIZED_ENUM;
        m_formalizer = false;
        ref_comp_name = "";
        ref_comp_package = "";
        R442_navigates_from_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R445_is_a_Selector_inst = SelectorImpl.EMPTY_SELECTOR;
        R4505_invoked_by_SetSelector_set = new SetSelectorSetImpl();
    }

    private InstanceSelectorImpl( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String ref_name, int m_rel_num, Cond m_conditionality, boolean m_formalizer, String ref_comp_name, String ref_comp_package ) {
        super(instanceId);
        this.context = context;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        this.ref_name = ref_name;
        this.m_rel_num = m_rel_num;
        this.m_conditionality = m_conditionality;
        this.m_formalizer = m_formalizer;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        R442_navigates_from_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R445_is_a_Selector_inst = SelectorImpl.EMPTY_SELECTOR;
        R4505_invoked_by_SetSelector_set = new SetSelectorSetImpl();
    }

    public static InstanceSelector create( Sql context ) throws XtumlException {
        InstanceSelector newInstanceSelector = new InstanceSelectorImpl( context );
        if ( context.addInstance( newInstanceSelector ) ) {
            newInstanceSelector.getRunContext().addChange(new InstanceCreatedDelta(newInstanceSelector, KEY_LETTERS));
            return newInstanceSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceSelector create( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String ref_name, int m_rel_num, Cond m_conditionality, boolean m_formalizer, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        InstanceSelector newInstanceSelector = new InstanceSelectorImpl( context, instanceId, ref_class_name, ref_class_package, ref_name, m_rel_num, m_conditionality, m_formalizer, ref_comp_name, ref_comp_package );
        if ( context.addInstance( newInstanceSelector ) ) {
            return newInstanceSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
            if ( !R4505_invoked_by_SetSelector().isEmpty() ) R4505_invoked_by_SetSelector().setSelector_class_name( ref_class_name );
        }
    }
    private String ref_class_package;
    @Override
    public void setClass_package(String ref_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_package, this.ref_class_package)) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
            if ( !R4505_invoked_by_SetSelector().isEmpty() ) R4505_invoked_by_SetSelector().setSelector_class_package( ref_class_package );
        }
    }
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return ref_class_package;
    }
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4505_invoked_by_SetSelector().isEmpty() ) R4505_invoked_by_SetSelector().setSelector_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    private int m_rel_num;
    @Override
    public void setRel_num(int m_rel_num) throws XtumlException {
        checkLiving();
        if (m_rel_num != this.m_rel_num) {
            final int oldValue = this.m_rel_num;
            this.m_rel_num = m_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_rel_num", oldValue, this.m_rel_num));
        }
    }
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return m_rel_num;
    }
    private Cond m_conditionality;
    @Override
    public void setConditionality(Cond m_conditionality) throws XtumlException {
        checkLiving();
        if (m_conditionality.inequality( this.m_conditionality)) {
            final Cond oldValue = this.m_conditionality;
            this.m_conditionality = m_conditionality;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_conditionality", oldValue, this.m_conditionality));
        }
    }
    @Override
    public Cond getConditionality() throws XtumlException {
        checkLiving();
        return m_conditionality;
    }
    private boolean m_formalizer;
    @Override
    public void setFormalizer(boolean m_formalizer) throws XtumlException {
        checkLiving();
        if (m_formalizer != this.m_formalizer) {
            final boolean oldValue = this.m_formalizer;
            this.m_formalizer = m_formalizer;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_formalizer", oldValue, this.m_formalizer));
        }
    }
    @Override
    public boolean getFormalizer() throws XtumlException {
        checkLiving();
        return m_formalizer;
    }
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
        return ref_comp_name;
    }
    @Override
    public void setComp_name(String ref_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_name, this.ref_comp_name)) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    private String ref_comp_package;
    @Override
    public void setComp_package(String ref_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_package, this.ref_comp_package)) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
        return ref_comp_package;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getClass_name(), getClass_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        Selector selector = self().R445_is_a_Selector();
        String type_name = selector.getType_reference_name();
        String inst_type_name = type_name;
        Type inst_type = selector.R446_selects_instances_of_TypeReference().R3800_based_on_Type().R407_is_a_InstSet().R406_defines_set_with_elements_of_type_ModelInst().R407_is_a_Type();
        if ( !inst_type.isEmpty() ) {
            inst_type_name = inst_type.getName();
        }
        boolean multiplicity_many = selector.getMultiplicity().equality(Mult.MANY);
        context().T().include( "class/t.instanceselector.java", inst_type_name, multiplicity_many, self(), type_name );
    }

    @Override
    public void render_empty() throws XtumlException {
        Selector selector = self().R445_is_a_Selector();
        String type_name = selector.getType_reference_name();
        boolean multiplicity_many = selector.getMultiplicity().equality(Mult.MANY);
        context().T().include( "class/t.instanceselector.empty.java", multiplicity_many, self(), type_name );
    }

    @Override
    public void render_interface() throws XtumlException {
        Selector selector = self().R445_is_a_Selector();
        String type_name = selector.getType_reference_name();
        String inst_type_name = type_name;
        Type inst_type = selector.R446_selects_instances_of_TypeReference().R3800_based_on_Type().R407_is_a_InstSet().R406_defines_set_with_elements_of_type_ModelInst().R407_is_a_Type();
        if ( !inst_type.isEmpty() ) {
            inst_type_name = inst_type.getName();
        }
        boolean multiplicity_many = selector.getMultiplicity().equality(Mult.MANY);
        context().T().include( "class/t.instanceselector.int.java", inst_type_name, multiplicity_many, self(), type_name );
    }



    // static operations


    // events


    // selections
    private ModelInst R442_navigates_from_ModelInst_inst;
    @Override
    public void setR442_navigates_from_ModelInst( ModelInst inst ) {
        R442_navigates_from_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R442_navigates_from_ModelInst() throws XtumlException {
        return R442_navigates_from_ModelInst_inst;
    }
    private Selector R445_is_a_Selector_inst;
    @Override
    public void setR445_is_a_Selector( Selector inst ) {
        R445_is_a_Selector_inst = inst;
    }
    @Override
    public Selector R445_is_a_Selector() throws XtumlException {
        return R445_is_a_Selector_inst;
    }
    private SetSelectorSet R4505_invoked_by_SetSelector_set;
    @Override
    public void addR4505_invoked_by_SetSelector( SetSelector inst ) {
        R4505_invoked_by_SetSelector_set.add(inst);
    }
    @Override
    public void removeR4505_invoked_by_SetSelector( SetSelector inst ) {
        R4505_invoked_by_SetSelector_set.remove(inst);
    }
    @Override
    public SetSelectorSet R4505_invoked_by_SetSelector() throws XtumlException {
        return R4505_invoked_by_SetSelector_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceSelector self() {
        return this;
    }

    @Override
    public InstanceSelector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCESELECTOR;
    }

}

class EmptyInstanceSelector extends ModelInstance<InstanceSelector,Sql> implements InstanceSelector {

    // attributes
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_num( int m_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setConditionality( Cond m_conditionality ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public Cond getConditionality() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFormalizer( boolean m_formalizer ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getFormalizer() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_empty() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_interface() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ModelInst R442_navigates_from_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public Selector R445_is_a_Selector() {
        return SelectorImpl.EMPTY_SELECTOR;
    }
    @Override
    public SetSelectorSet R4505_invoked_by_SetSelector() {
        return (new SetSelectorSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return InstanceSelectorImpl.KEY_LETTERS;
    }

    @Override
    public InstanceSelector self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceSelector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
    }

}
