package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.InstSetSet;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.SetSelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.SetSelectorSetImpl;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class InstSetSetImpl extends InstanceSet<InstSetSet,InstSet> implements InstSetSet {

    public InstSetSetImpl() {
    }

    public InstSetSetImpl(Comparator<? super InstSet> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( InstSet instset : this ) instset.setName( ref_name );
    }
    @Override
    public void setClass_package( String ref_class_package ) throws XtumlException {
        for ( InstSet instset : this ) instset.setClass_package( ref_class_package );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( InstSet instset : this ) instset.setComp_name( ref_comp_name );
    }
    @Override
    public void setComparator( String m_comparator ) throws XtumlException {
        for ( InstSet instset : this ) instset.setComparator( m_comparator );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( InstSet instset : this ) instset.setPackage( ref_package );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( InstSet instset : this ) instset.setComp_package( ref_comp_package );
    }
    @Override
    public void setExtends( String m_extends ) throws XtumlException {
        for ( InstSet instset : this ) instset.setExtends( m_extends );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( InstSet instset : this ) instset.setClass_name( ref_class_name );
    }


    // selections
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( InstSet instset : this ) fileset.add( instset.R401_is_a_File() );
        return fileset;
    }
    @Override
    public ModelInstSet R406_defines_set_with_elements_of_type_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( InstSet instset : this ) modelinstset.add( instset.R406_defines_set_with_elements_of_type_ModelInst() );
        return modelinstset;
    }
    @Override
    public TypeSet R407_is_a_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( InstSet instset : this ) typeset.add( instset.R407_is_a_Type() );
        return typeset;
    }
    @Override
    public SetSelectorSet R444_selects_instances_through_SetSelector() throws XtumlException {
        SetSelectorSet setselectorset = new SetSelectorSetImpl();
        for ( InstSet instset : this ) setselectorset.addAll( instset.R444_selects_instances_through_SetSelector() );
        return setselectorset;
    }


    @Override
    public InstSet nullElement() {
        return InstSetImpl.EMPTY_INSTSET;
    }

    @Override
    public InstSetSet emptySet() {
      return new InstSetSetImpl();
    }

    @Override
    public InstSetSet emptySet(Comparator<? super InstSet> comp) {
      return new InstSetSetImpl(comp);
    }

    @Override
    public List<InstSet> elements() {
        InstSet[] elements = toArray(new InstSet[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
