package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.AttributeReference;
import io.ciera.tool.sql.architecture.classes.AttributeReferenceSet;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class AttributeReferenceSetImpl extends InstanceSet<AttributeReferenceSet,AttributeReference> implements AttributeReferenceSet {

    public AttributeReferenceSetImpl() {
    }

    public AttributeReferenceSetImpl(Comparator<? super AttributeReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPart_phrase( String ref_part_phrase ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setPart_phrase( ref_part_phrase );
    }
    @Override
    public void setReferring_attribute_name( String ref_referring_attribute_name ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setReferring_attribute_name( ref_referring_attribute_name );
    }
    @Override
    public void setReferred_to_attribute_class_package( String ref_referred_to_attribute_class_package ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setReferred_to_attribute_class_package( ref_referred_to_attribute_class_package );
    }
    @Override
    public void setReferring_attribute_class_package( String ref_referring_attribute_class_package ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setReferring_attribute_class_package( ref_referring_attribute_class_package );
    }
    @Override
    public void setReferred_to_attribute_name( String ref_referred_to_attribute_name ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setReferred_to_attribute_name( ref_referred_to_attribute_name );
    }
    @Override
    public void setForm_name( String ref_form_name ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setForm_name( ref_form_name );
    }
    @Override
    public void setPart_name( String ref_part_name ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setPart_name( ref_part_name );
    }
    @Override
    public void setForm_phrase( String ref_form_phrase ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setForm_phrase( ref_form_phrase );
    }
    @Override
    public void setReferring_attribute_class_name( String ref_referring_attribute_class_name ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setReferring_attribute_class_name( ref_referring_attribute_class_name );
    }
    @Override
    public void setReferred_to_attribute_class_name( String ref_referred_to_attribute_class_name ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setReferred_to_attribute_class_name( ref_referred_to_attribute_class_name );
    }
    @Override
    public void setRel_num( int ref_rel_num ) throws XtumlException {
        for ( AttributeReference attributereference : this ) attributereference.setRel_num( ref_rel_num );
    }


    // selections
    @Override
    public AttributeSet R4506_has_value_provided_by_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( AttributeReference attributereference : this ) attributeset.add( attributereference.R4506_has_value_provided_by_Attribute() );
        return attributeset;
    }
    @Override
    public AttributeSet R4506_provides_value_for_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( AttributeReference attributereference : this ) attributeset.add( attributereference.R4506_provides_value_for_Attribute() );
        return attributeset;
    }
    @Override
    public ClassRelationshipSet R4511_refers_to_another_attribute_through_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( AttributeReference attributereference : this ) classrelationshipset.add( attributereference.R4511_refers_to_another_attribute_through_ClassRelationship() );
        return classrelationshipset;
    }


    @Override
    public AttributeReference nullElement() {
        return AttributeReferenceImpl.EMPTY_ATTRIBUTEREFERENCE;
    }

    @Override
    public AttributeReferenceSet emptySet() {
      return new AttributeReferenceSetImpl();
    }

    @Override
    public AttributeReferenceSet emptySet(Comparator<? super AttributeReference> comp) {
      return new AttributeReferenceSetImpl(comp);
    }

    @Override
    public List<AttributeReference> elements() {
        return Arrays.asList(toArray(new AttributeReference[0]));
    }

}
