package io.ciera.tool.sql.architecture.application.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.ApplicationExecutorSet;
import io.ciera.tool.sql.architecture.application.ApplicationSet;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ApplicationExecutorSetImpl;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ApplicationSetImpl extends InstanceSet<ApplicationSet,Application> implements ApplicationSet {

    public ApplicationSetImpl() {
    }

    public ApplicationSetImpl(Comparator<? super Application> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setAsync( boolean m_async ) throws XtumlException {
        for ( Application application : this ) application.setAsync( m_async );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( Application application : this ) application.setPackage( ref_package );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Application application : this ) application.setName( ref_name );
    }


    // selections
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( Application application : this ) fileset.add( application.R401_is_a_File() );
        return fileset;
    }
    @Override
    public ApplicationExecutorSet R4027_delegates_execution_to_ApplicationExecutor() throws XtumlException {
        ApplicationExecutorSet applicationexecutorset = new ApplicationExecutorSetImpl();
        for ( Application application : this ) applicationexecutorset.addAll( application.R4027_delegates_execution_to_ApplicationExecutor() );
        return applicationexecutorset;
    }
    @Override
    public ComponentInstantiationSet R426_is_broken_into_ComponentInstantiation() throws XtumlException {
        ComponentInstantiationSet componentinstantiationset = new ComponentInstantiationSetImpl();
        for ( Application application : this ) componentinstantiationset.addAll( application.R426_is_broken_into_ComponentInstantiation() );
        return componentinstantiationset;
    }


    @Override
    public Application nullElement() {
        return ApplicationImpl.EMPTY_APPLICATION;
    }

    @Override
    public ApplicationSet emptySet() {
      return new ApplicationSetImpl();
    }

    @Override
    public ApplicationSet emptySet(Comparator<? super Application> comp) {
      return new ApplicationSetImpl(comp);
    }

    @Override
    public List<Application> elements() {
        Application[] elements = toArray(new Application[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
