package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum StateChangeType implements IXtumlType<StateChangeType> {

    UNINITIALIZED_ENUM( -1 ),
    ENTRY( 0 ),
    EXIT( 1 );

    private final int value;

    StateChangeType() {
        value = -1;
    }

    StateChangeType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( StateChangeType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public StateChangeType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static StateChangeType deserialize(Object o) throws XtumlException {
        if (o instanceof StateChangeType) {
            return (StateChangeType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static StateChangeType valueOf(int value) {
        switch( value ) {
        case 0:
            return ENTRY;
        case 1:
            return EXIT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
