package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Scope implements IXtumlType<Scope> {

    UNINITIALIZED_ENUM( -1 ),
    CLASS( 0 ),
    INSTANCE( 1 );

    private final int value;

    Scope() {
        value = -1;
    }

    Scope( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Scope value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Scope value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Scope deserialize(Object o) throws XtumlException {
        if (o instanceof Scope) {
            return (Scope)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Scope valueOf(int value) {
        switch( value ) {
        case 0:
            return CLASS;
        case 1:
            return INSTANCE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
