package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum ActionDialect implements IXtumlType<ActionDialect> {

    UNINITIALIZED_ENUM( -1 ),
    ALF( 3 ),
    ASL( 2 ),
    C( 5 ),
    JAVA( 4 ),
    MASL( 1 ),
    NONE( 6 ),
    OAL( 0 );

    private final int value;

    ActionDialect() {
        value = -1;
    }

    ActionDialect( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( ActionDialect value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public ActionDialect value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ActionDialect deserialize(Object o) throws XtumlException {
        if (o instanceof ActionDialect) {
            return (ActionDialect)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static ActionDialect valueOf(int value) {
        switch( value ) {
        case 3:
            return ALF;
        case 2:
            return ASL;
        case 5:
            return C;
        case 4:
            return JAVA;
        case 1:
            return MASL;
        case 6:
            return NONE;
        case 0:
            return OAL;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
